/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstancePropertiesState;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstancePropertiesStateFluent;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstancePropertiesStateFluentImpl;

public class ServiceInstancePropertiesStateBuilder
extends ServiceInstancePropertiesStateFluentImpl<ServiceInstancePropertiesStateBuilder>
implements VisitableBuilder<ServiceInstancePropertiesState, ServiceInstancePropertiesStateBuilder> {
    ServiceInstancePropertiesStateFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceInstancePropertiesStateBuilder() {
        this(true);
    }

    public ServiceInstancePropertiesStateBuilder(Boolean validationEnabled) {
        this(new ServiceInstancePropertiesState(), validationEnabled);
    }

    public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceInstancePropertiesState(), validationEnabled);
    }

    public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent, ServiceInstancePropertiesState instance) {
        this(fluent, instance, true);
    }

    public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent, ServiceInstancePropertiesState instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
        fluent.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
        fluent.withParameterChecksum(instance.getParameterChecksum());
        fluent.withParameters(instance.getParameters());
        fluent.withUserInfo(instance.getUserInfo());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesState instance) {
        this(instance, (Boolean)true);
    }

    public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesState instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
        this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
        this.withParameterChecksum(instance.getParameterChecksum());
        this.withParameters(instance.getParameters());
        this.withUserInfo(instance.getUserInfo());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstancePropertiesStateBuilder(Validator validator) {
        this(new ServiceInstancePropertiesState(), (Boolean)true);
    }

    public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent, ServiceInstancePropertiesState instance, Validator validator) {
        this.fluent = fluent;
        fluent.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
        fluent.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
        fluent.withParameterChecksum(instance.getParameterChecksum());
        fluent.withParameters(instance.getParameters());
        fluent.withUserInfo(instance.getUserInfo());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesState instance, Validator validator) {
        this.fluent = this;
        this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
        this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
        this.withParameterChecksum(instance.getParameterChecksum());
        this.withParameters(instance.getParameters());
        this.withUserInfo(instance.getUserInfo());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServiceInstancePropertiesState build() {
        ServiceInstancePropertiesState buildable = new ServiceInstancePropertiesState(this.fluent.getClusterServicePlanExternalID(), this.fluent.getClusterServicePlanExternalName(), this.fluent.getParameterChecksum(), this.fluent.getParameters(), this.fluent.getUserInfo());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstancePropertiesStateBuilder that = (ServiceInstancePropertiesStateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

