/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.applicationcrd.api.model;

import io.dekorate.deps.applicationcrd.api.model.Schema;
import io.dekorate.deps.applicationcrd.api.model.SchemaFluent;
import io.dekorate.deps.applicationcrd.api.model.SchemaFluentImpl;
import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;

public class SchemaBuilder
extends SchemaFluentImpl<SchemaBuilder>
implements VisitableBuilder<Schema, SchemaBuilder> {
    SchemaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SchemaBuilder() {
        this(true);
    }

    public SchemaBuilder(Boolean validationEnabled) {
        this(new Schema(), validationEnabled);
    }

    public SchemaBuilder(SchemaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SchemaBuilder(SchemaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Schema(), validationEnabled);
    }

    public SchemaBuilder(SchemaFluent<?> fluent, Schema instance) {
        this(fluent, instance, true);
    }

    public SchemaBuilder(SchemaFluent<?> fluent, Schema instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApplication(instance.getApplication());
        fluent.withApplicationList(instance.getApplicationList());
        this.validationEnabled = validationEnabled;
    }

    public SchemaBuilder(Schema instance) {
        this(instance, (Boolean)true);
    }

    public SchemaBuilder(Schema instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApplication(instance.getApplication());
        this.withApplicationList(instance.getApplicationList());
        this.validationEnabled = validationEnabled;
    }

    public SchemaBuilder(Validator validator) {
        this(new Schema(), (Boolean)true);
    }

    public SchemaBuilder(SchemaFluent<?> fluent, Schema instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApplication(instance.getApplication());
        fluent.withApplicationList(instance.getApplicationList());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SchemaBuilder(Schema instance, Validator validator) {
        this.fluent = this;
        this.withApplication(instance.getApplication());
        this.withApplicationList(instance.getApplicationList());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Schema build() {
        Schema buildable = new Schema(this.fluent.getApplication(), this.fluent.getApplicationList());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaBuilder that = (SchemaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

