/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.ListMeta;
import io.dekorate.deps.kubernetes.api.model.ListMetaBuilder;
import io.dekorate.deps.kubernetes.api.model.ListMetaFluentImpl;
import io.dekorate.deps.kubernetes.api.model.Node;
import io.dekorate.deps.kubernetes.api.model.NodeBuilder;
import io.dekorate.deps.kubernetes.api.model.NodeFluentImpl;
import io.dekorate.deps.kubernetes.api.model.NodeList;
import io.dekorate.deps.kubernetes.api.model.NodeListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeListFluentImpl<A extends NodeListFluent<A>>
extends BaseFluent<A>
implements NodeListFluent<A> {
    private String apiVersion;
    private List<NodeBuilder> items;
    private String kind;
    private ListMetaBuilder metadata;

    public NodeListFluentImpl() {
    }

    public NodeListFluentImpl(NodeList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, Node item) {
        if (this.items == null) {
            this.items = new ArrayList<NodeBuilder>();
        }
        NodeBuilder builder = new NodeBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Node item) {
        if (this.items == null) {
            this.items = new ArrayList<NodeBuilder>();
        }
        NodeBuilder builder = new NodeBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Node ... items) {
        if (this.items == null) {
            this.items = new ArrayList<NodeBuilder>();
        }
        for (Node item : items) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Node> items) {
        if (this.items == null) {
            this.items = new ArrayList<NodeBuilder>();
        }
        for (Node item : items) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Node ... items) {
        for (Node item : items) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Node> items) {
        for (Node item : items) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Node> getItems() {
        return NodeListFluentImpl.build(this.items);
    }

    @Override
    public List<Node> buildItems() {
        return NodeListFluentImpl.build(this.items);
    }

    @Override
    public Node buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Node buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Node buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Node buildMatchingItem(Predicate<NodeBuilder> predicate) {
        for (NodeBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<NodeBuilder> predicate) {
        for (NodeBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Node> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<NodeBuilder>();
            for (Node item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<NodeBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(Node ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Node item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public NodeListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public NodeListFluent.ItemsNested<A> addNewItemLike(Node item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public NodeListFluent.ItemsNested<A> setNewItemLike(int index, Node item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public NodeListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public NodeListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public NodeListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public NodeListFluent.ItemsNested<A> editMatchingItem(Predicate<NodeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    @Override
    public NodeListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public NodeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public NodeListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public NodeListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ListMetaBuilder().build());
    }

    @Override
    public NodeListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeListFluentImpl that = (NodeListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<NodeListFluent.MetadataNested<N>>
    implements NodeListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends NodeFluentImpl<NodeListFluent.ItemsNested<N>>
    implements NodeListFluent.ItemsNested<N>,
    Nested<N> {
        private final NodeBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Node item) {
            this.index = index;
            this.builder = new NodeBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new NodeBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

