/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.openshift.api.model.GitSourceRevision;
import io.dekorate.deps.openshift.api.model.GitSourceRevisionFluent;
import io.dekorate.deps.openshift.api.model.SourceControlUser;
import io.dekorate.deps.openshift.api.model.SourceControlUserBuilder;
import io.dekorate.deps.openshift.api.model.SourceControlUserFluentImpl;

public class GitSourceRevisionFluentImpl<A extends GitSourceRevisionFluent<A>>
extends BaseFluent<A>
implements GitSourceRevisionFluent<A> {
    private SourceControlUserBuilder author;
    private String commit;
    private SourceControlUserBuilder committer;
    private String message;

    public GitSourceRevisionFluentImpl() {
    }

    public GitSourceRevisionFluentImpl(GitSourceRevision instance) {
        this.withAuthor(instance.getAuthor());
        this.withCommit(instance.getCommit());
        this.withCommitter(instance.getCommitter());
        this.withMessage(instance.getMessage());
    }

    @Override
    @Deprecated
    public SourceControlUser getAuthor() {
        return this.author != null ? this.author.build() : null;
    }

    @Override
    public SourceControlUser buildAuthor() {
        return this.author != null ? this.author.build() : null;
    }

    @Override
    public A withAuthor(SourceControlUser author) {
        this._visitables.get("author").remove(this.author);
        if (author != null) {
            this.author = new SourceControlUserBuilder(author);
            this._visitables.get("author").add(this.author);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthor() {
        return this.author != null;
    }

    @Override
    public A withNewAuthor(String email, String name) {
        return this.withAuthor(new SourceControlUser(email, name));
    }

    @Override
    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthor() {
        return new AuthorNestedImpl();
    }

    @Override
    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthorLike(SourceControlUser item) {
        return new AuthorNestedImpl(item);
    }

    @Override
    public GitSourceRevisionFluent.AuthorNested<A> editAuthor() {
        return this.withNewAuthorLike(this.getAuthor());
    }

    @Override
    public GitSourceRevisionFluent.AuthorNested<A> editOrNewAuthor() {
        return this.withNewAuthorLike(this.getAuthor() != null ? this.getAuthor() : new SourceControlUserBuilder().build());
    }

    @Override
    public GitSourceRevisionFluent.AuthorNested<A> editOrNewAuthorLike(SourceControlUser item) {
        return this.withNewAuthorLike(this.getAuthor() != null ? this.getAuthor() : item);
    }

    @Override
    public String getCommit() {
        return this.commit;
    }

    @Override
    public A withCommit(String commit) {
        this.commit = commit;
        return (A)this;
    }

    @Override
    public Boolean hasCommit() {
        return this.commit != null;
    }

    @Override
    public A withNewCommit(String arg1) {
        return this.withCommit(new String(arg1));
    }

    @Override
    public A withNewCommit(StringBuilder arg1) {
        return this.withCommit(new String(arg1));
    }

    @Override
    public A withNewCommit(StringBuffer arg1) {
        return this.withCommit(new String(arg1));
    }

    @Override
    @Deprecated
    public SourceControlUser getCommitter() {
        return this.committer != null ? this.committer.build() : null;
    }

    @Override
    public SourceControlUser buildCommitter() {
        return this.committer != null ? this.committer.build() : null;
    }

    @Override
    public A withCommitter(SourceControlUser committer) {
        this._visitables.get("committer").remove(this.committer);
        if (committer != null) {
            this.committer = new SourceControlUserBuilder(committer);
            this._visitables.get("committer").add(this.committer);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommitter() {
        return this.committer != null;
    }

    @Override
    public A withNewCommitter(String email, String name) {
        return this.withCommitter(new SourceControlUser(email, name));
    }

    @Override
    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitter() {
        return new CommitterNestedImpl();
    }

    @Override
    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitterLike(SourceControlUser item) {
        return new CommitterNestedImpl(item);
    }

    @Override
    public GitSourceRevisionFluent.CommitterNested<A> editCommitter() {
        return this.withNewCommitterLike(this.getCommitter());
    }

    @Override
    public GitSourceRevisionFluent.CommitterNested<A> editOrNewCommitter() {
        return this.withNewCommitterLike(this.getCommitter() != null ? this.getCommitter() : new SourceControlUserBuilder().build());
    }

    @Override
    public GitSourceRevisionFluent.CommitterNested<A> editOrNewCommitterLike(SourceControlUser item) {
        return this.withNewCommitterLike(this.getCommitter() != null ? this.getCommitter() : item);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public A withNewMessage(String arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuilder arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuffer arg1) {
        return this.withMessage(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitSourceRevisionFluentImpl that = (GitSourceRevisionFluentImpl)o;
        if (this.author != null ? !this.author.equals(that.author) : that.author != null) {
            return false;
        }
        if (this.commit != null ? !this.commit.equals(that.commit) : that.commit != null) {
            return false;
        }
        if (this.committer != null ? !this.committer.equals(that.committer) : that.committer != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    public class CommitterNestedImpl<N>
    extends SourceControlUserFluentImpl<GitSourceRevisionFluent.CommitterNested<N>>
    implements GitSourceRevisionFluent.CommitterNested<N>,
    Nested<N> {
        private final SourceControlUserBuilder builder;

        CommitterNestedImpl(SourceControlUser item) {
            this.builder = new SourceControlUserBuilder(this, item);
        }

        CommitterNestedImpl() {
            this.builder = new SourceControlUserBuilder(this);
        }

        @Override
        public N and() {
            return (N)GitSourceRevisionFluentImpl.this.withCommitter(this.builder.build());
        }

        @Override
        public N endCommitter() {
            return this.and();
        }
    }

    public class AuthorNestedImpl<N>
    extends SourceControlUserFluentImpl<GitSourceRevisionFluent.AuthorNested<N>>
    implements GitSourceRevisionFluent.AuthorNested<N>,
    Nested<N> {
        private final SourceControlUserBuilder builder;

        AuthorNestedImpl(SourceControlUser item) {
            this.builder = new SourceControlUserBuilder(this, item);
        }

        AuthorNestedImpl() {
            this.builder = new SourceControlUserBuilder(this);
        }

        @Override
        public N and() {
            return (N)GitSourceRevisionFluentImpl.this.withAuthor(this.builder.build());
        }

        @Override
        public N endAuthor() {
            return this.and();
        }
    }
}

