/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.ListMeta;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstance;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceBuilder;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceFluentImpl;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceList;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceInstanceListFluentImpl<A extends ServiceInstanceListFluent<A>>
extends BaseFluent<A>
implements ServiceInstanceListFluent<A> {
    private String apiVersion;
    private List<ServiceInstanceBuilder> items;
    private String kind;
    private ListMeta metadata;

    public ServiceInstanceListFluentImpl() {
    }

    public ServiceInstanceListFluentImpl(ServiceInstanceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, ServiceInstance item) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceInstanceBuilder>();
        }
        ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ServiceInstance item) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceInstanceBuilder>();
        }
        ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ServiceInstance ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceInstanceBuilder>();
        }
        for (ServiceInstance item : items) {
            ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ServiceInstance> items) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceInstanceBuilder>();
        }
        for (ServiceInstance item : items) {
            ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ServiceInstance ... items) {
        for (ServiceInstance item : items) {
            ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ServiceInstance> items) {
        for (ServiceInstance item : items) {
            ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceInstance> getItems() {
        return ServiceInstanceListFluentImpl.build(this.items);
    }

    @Override
    public List<ServiceInstance> buildItems() {
        return ServiceInstanceListFluentImpl.build(this.items);
    }

    @Override
    public ServiceInstance buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ServiceInstance buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ServiceInstance buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ServiceInstance buildMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
        for (ServiceInstanceBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
        for (ServiceInstanceBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ServiceInstance> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ServiceInstanceBuilder>();
            for (ServiceInstance item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<ServiceInstanceBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(ServiceInstance ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ServiceInstance item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> addNewItemLike(ServiceInstance item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> setNewItemLike(int index, ServiceInstance item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstanceListFluentImpl that = (ServiceInstanceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends ServiceInstanceFluentImpl<ServiceInstanceListFluent.ItemsNested<N>>
    implements ServiceInstanceListFluent.ItemsNested<N>,
    Nested<N> {
        private final ServiceInstanceBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ServiceInstance item) {
            this.index = index;
            this.builder = new ServiceInstanceBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceInstanceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceInstanceListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

