/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.networking.NetworkPolicy;
import io.dekorate.deps.kubernetes.api.model.networking.NetworkPolicyBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.internal.NetworkPolicyOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class NetworkPolicyHandler
implements ResourceHandler<NetworkPolicy, NetworkPolicyBuilder> {
    @Override
    public String getKind() {
        return NetworkPolicy.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "networking.k8s.io/v1";
    }

    @Override
    public NetworkPolicy create(OkHttpClient client, Config config, String namespace, NetworkPolicy item) {
        return (NetworkPolicy)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new NetworkPolicy[0]);
    }

    @Override
    public NetworkPolicy replace(OkHttpClient client, Config config, String namespace, NetworkPolicy item) {
        return (NetworkPolicy)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public NetworkPolicy reload(OkHttpClient client, Config config, String namespace, NetworkPolicy item) {
        return (NetworkPolicy)((Gettable)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NetworkPolicyBuilder edit(NetworkPolicy item) {
        return new NetworkPolicyBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, NetworkPolicy item) {
        return (Boolean)new NetworkPolicyOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetworkPolicy item, Watcher<NetworkPolicy> watcher) {
        return (Watch)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetworkPolicy item, String resourceVersion, Watcher<NetworkPolicy> watcher) {
        return (Watch)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public NetworkPolicy waitUntilReady(OkHttpClient client, Config config, String namespace, NetworkPolicy item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetworkPolicy)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public NetworkPolicy waitUntilCondition(OkHttpClient client, Config config, String namespace, NetworkPolicy item, Predicate<NetworkPolicy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetworkPolicy)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

