/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.generator;

import io.dekorate.Generator;
import io.dekorate.Handler;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.configurator.AddLivenessProbeConfigurator;
import io.dekorate.kubernetes.configurator.AddReadinessProbeConfigurator;
import io.dekorate.kubernetes.decorator.AddRoleBindingResourceDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplyServiceAccountNamedDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.prometheus.config.EditableServiceMonitorConfig;
import io.dekorate.prometheus.decorator.EndpointPathDecorator;
import io.dekorate.spring.config.SpringApplicationConfig;
import io.dekorate.spring.config.SpringApplicationConfigBuilder;
import io.dekorate.spring.configurator.SetSpringBootRuntime;
import io.dekorate.spring.configurator.SetSpringBootVersion;
import java.util.Collections;
import java.util.Map;

public interface SpringBootApplicationGenerator
extends Generator,
WithSession {
    public static final Map<String, Object> SPRING_BOOT_APPLICATION = Collections.emptyMap();
    public static final Logger LOGGER = LoggerFactory.getLogger();

    default public void add(Map map) {
        final Session session = this.getSession();
        session.configurators().add(new ConfigurationSupplier((VisitableBuilder)new SpringApplicationConfigBuilder()));
        session.configurators().add((Configurator)new SetSpringBootRuntime());
        session.configurators().add((Configurator)new SetSpringBootVersion());
        session.handlers().add(new Handler(){

            public int order() {
                return 410;
            }

            public void handle(Configuration config) {
                LOGGER.info("Processing service monitor config.");
                session.resources().decorate((Decorator)new EndpointPathDecorator("http", "/actuator/prometheus"));
            }

            public boolean canHandle(Class config) {
                return SpringApplicationConfig.class.equals((Object)config) || EditableServiceMonitorConfig.class.equals((Object)config);
            }
        });
        if (this.isActuatorAvailable()) {
            session.configurators().add((Configurator)new AddLivenessProbeConfigurator((Probe)((ProbeBuilder)new ProbeBuilder().withHttpActionPath("/actuator/info")).build(), false));
            session.configurators().add((Configurator)new AddReadinessProbeConfigurator((Probe)((ProbeBuilder)new ProbeBuilder().withHttpActionPath("/actuator/health")).build(), false));
        }
        if (this.isSpringCloudKubernetesAvailable()) {
            session.handlers().add(new Handler(){

                public int order() {
                    return 310;
                }

                public void handle(Configuration config) {
                    LOGGER.info("Detected spring cloud kubernetes.");
                    session.resources().decorate((Decorator)new ApplyServiceAccountNamedDecorator());
                    session.resources().decorate((Decorator)new AddServiceAccountResourceDecorator());
                    session.resources().decorate((Decorator)new AddRoleBindingResourceDecorator("view"));
                }

                public boolean canHandle(Class config) {
                    return SpringApplicationConfig.class.isAssignableFrom(config);
                }
            });
        }
    }

    default public boolean isActuatorAvailable() {
        try {
            Class<?> c = Class.forName("org.springframework.boot.actuate.health.HealthIndicator");
            return c != null;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    default public boolean isSpringCloudKubernetesAvailable() {
        try {
            Class<?> c = Class.forName("org.springframework.cloud.kubernetes.KubernetesAutoConfiguration");
            return c != null;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }
}

