/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.apt;

import io.dekorate.ConfigurationRegistry;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Session;
import io.dekorate.config.AdditionalResourcesLocator;
import io.dekorate.doc.Description;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.dekorate.spring.config.SpringBootApplicationGenerator;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@Description(value="Detects Spring Boot and set the runtime attribute to Spring Boot.")
@SupportedAnnotationTypes(value={"org.springframework.boot.autoconfigure.SpringBootApplication"})
public class SpringBootApplicationProcessor
extends AbstractAnnotationProcessor
implements SpringBootApplicationGenerator {
    private static final String SPRING_PROFILE = "spring.profiles.active";
    private final Logger LOGGER = LoggerFactory.getLogger();

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.LOGGER.info("Found @SpringBootApplication on: " + element.toString());
            }
        }
        ArrayList<String> resourceNames = new ArrayList<String>();
        resourceNames.add("application.properties");
        resourceNames.add("application.yaml");
        resourceNames.add("application.yml");
        resourceNames.addAll(AdditionalResourcesLocator.getAdditionalResources());
        Optional.ofNullable(System.getProperty(SPRING_PROFILE)).filter(str -> !str.isEmpty()).ifPresent(profile -> {
            resourceNames.add("application-" + profile + ".properties");
            resourceNames.add("application-" + profile + ".yaml");
            resourceNames.add("application-" + profile + ".yml");
        });
        this.getSession().addPropertyConfiguration(this.readApplicationConfig(resourceNames.toArray(new String[resourceNames.size()])));
        this.addPropertyConfiguration(SPRING_BOOT_APPLICATION);
        return false;
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return Session.getSession().getConfigurationRegistry();
    }
}

