/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.docker.buildservice;

import io.dekorate.BuildService;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.utils.Exec;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;
import java.io.File;

public class DockerBuildService
implements BuildService {
    private Logger LOGGER = LoggerFactory.getLogger();
    private final File dockerFile;
    private final String image;
    private final Exec.ProjectExec exec;
    private final Project project;
    private final ImageConfiguration config;

    public DockerBuildService(Project project, ImageConfiguration config) {
        this.project = project;
        this.config = config;
        this.exec = Exec.inProject((Project)project);
        this.dockerFile = project.getRoot().resolve(Strings.isNotNullOrEmpty((String)config.getDockerFile()) ? config.getDockerFile() : "Dockerfile").toFile();
        this.image = Images.getImage((String)config.getRegistry(), (String)config.getGroup(), (String)config.getName(), (String)config.getVersion());
    }

    public void build() {
        this.LOGGER.info("Performing docker build.");
        this.exec.commands(new String[]{"docker", "build", "-f" + this.dockerFile.getAbsolutePath(), "-t" + this.image, this.project.getRoot().toAbsolutePath().toString()});
    }

    public void push() {
        this.LOGGER.info("Performing docker push.");
        this.exec.commands(new String[]{"docker", "push", this.image});
    }
}

