/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.docker.config;

import io.dekorate.docker.config.DockerBuildConfigBuilder;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class DockerBuildConfig
extends ImageConfiguration {
    private Boolean enabled;
    private Boolean autoDeployEnabled;

    public DockerBuildConfig() {
    }

    public DockerBuildConfig(Project project, Map<ConfigKey, Object> attributes, String registry, String group, String name, String version, String image, String dockerFile, Boolean autoBuildEnabled, Boolean autoPushEnabled, Boolean enabled, Boolean autoDeployEnabled) {
        super(project, attributes, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled);
        this.enabled = enabled;
        this.autoDeployEnabled = autoDeployEnabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled != null && this.autoDeployEnabled != false;
    }

    public static DockerBuildConfigBuilder newDockerBuildConfigBuilder() {
        return new DockerBuildConfigBuilder();
    }

    public static DockerBuildConfigBuilder newDockerBuildConfigBuilderFromDefaults() {
        return (DockerBuildConfigBuilder)((DockerBuildConfigBuilder)((DockerBuildConfigBuilder)((DockerBuildConfigBuilder)((DockerBuildConfigBuilder)new DockerBuildConfigBuilder().withEnabled(true)).withDockerFile("Dockerfile")).withAutoPushEnabled(false)).withAutoBuildEnabled(false)).withAutoDeployEnabled(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerBuildConfig that = (DockerBuildConfig)((Object)o);
        if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
            return false;
        }
        return !(this.autoDeployEnabled != null ? !this.autoDeployEnabled.equals(that.autoDeployEnabled) : that.autoDeployEnabled != null);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.autoDeployEnabled, super.hashCode());
    }
}

