/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.docker.config;

import io.dekorate.docker.config.DockerBuildConfig;
import io.dekorate.docker.config.DockerBuildConfigFluent;
import io.dekorate.docker.config.DockerBuildConfigFluentImpl;
import io.dekorate.docker.config.EditableDockerBuildConfig;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class DockerBuildConfigBuilder
extends DockerBuildConfigFluentImpl<DockerBuildConfigBuilder>
implements VisitableBuilder<DockerBuildConfig, DockerBuildConfigBuilder> {
    DockerBuildConfigFluent<?> fluent;
    Boolean validationEnabled;

    public DockerBuildConfigBuilder() {
        this(false);
    }

    public DockerBuildConfigBuilder(Boolean validationEnabled) {
        this(new DockerBuildConfig(), validationEnabled);
    }

    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DockerBuildConfig(), validationEnabled);
    }

    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent, DockerBuildConfig instance) {
        this(fluent, instance, false);
    }

    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent, DockerBuildConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProject(instance.getProject());
        fluent.withAttributes(instance.getAttributes());
        fluent.withEnabled(instance.getEnabled());
        fluent.withRegistry(instance.getRegistry());
        fluent.withGroup(instance.getGroup());
        fluent.withName(instance.getName());
        fluent.withVersion(instance.getVersion());
        fluent.withImage(instance.getImage());
        fluent.withDockerFile(instance.getDockerFile());
        fluent.withAutoBuildEnabled(instance.getAutoBuildEnabled());
        fluent.withAutoPushEnabled(instance.getAutoPushEnabled());
        fluent.withAutoLoadEnabled(instance.isAutoLoadEnabled());
        fluent.withAutoDeployEnabled(instance.getAutoDeployEnabled());
        this.validationEnabled = validationEnabled;
    }

    public DockerBuildConfigBuilder(DockerBuildConfig instance) {
        this(instance, (Boolean)false);
    }

    public DockerBuildConfigBuilder(DockerBuildConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withEnabled(instance.getEnabled());
        this.withRegistry(instance.getRegistry());
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withImage(instance.getImage());
        this.withDockerFile(instance.getDockerFile());
        this.withAutoBuildEnabled(instance.getAutoBuildEnabled());
        this.withAutoPushEnabled(instance.getAutoPushEnabled());
        this.withAutoLoadEnabled(instance.isAutoLoadEnabled());
        this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
        this.validationEnabled = validationEnabled;
    }

    public EditableDockerBuildConfig build() {
        EditableDockerBuildConfig buildable = new EditableDockerBuildConfig(this.fluent.getProject(), this.fluent.getAttributes(), this.fluent.getEnabled(), this.fluent.getRegistry(), this.fluent.getGroup(), this.fluent.getName(), this.fluent.getVersion(), this.fluent.getImage(), this.fluent.getDockerFile(), this.fluent.getAutoBuildEnabled(), this.fluent.getAutoPushEnabled(), this.fluent.getAutoLoadEnabled(), this.fluent.getAutoDeployEnabled());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerBuildConfigBuilder that = (DockerBuildConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

