package io.dekorate.docker.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class DockerBuildConfig extends ImageConfiguration{
  public DockerBuildConfig() {
  }
  
  public DockerBuildConfig(Project project,Map<ConfigKey,Object> attributes,Boolean enabled,String registry,String group,String name,String version,String image,String dockerFile,Boolean autoBuildEnabled,Boolean autoPushEnabled,Boolean autoLoadEnabled,Boolean autoDeployEnabled) {
    super(project, attributes, enabled, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled, autoLoadEnabled);
    this.autoDeployEnabled = autoDeployEnabled;
  }
  private Boolean autoDeployEnabled;
  
  
  /**
   * Flag to trigger the registration of the deploy hook. It's generally
   * preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.
   * @return True for automatic registration of the build hook.
   */
  public Boolean getAutoDeployEnabled() {
    return this.autoDeployEnabled;
  }
  
  
  /**
   * Flag to trigger the registration of the deploy hook. It's generally
   * preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.
   * @return True for automatic registration of the build hook.
   */
  public boolean isAutoDeployEnabled() {
    return this.autoDeployEnabled != null &&  this.autoDeployEnabled;
  }
  
  public static DockerBuildConfigBuilder newDockerBuildConfigBuilder() {
    return new DockerBuildConfigBuilder();
  }
  
  public static DockerBuildConfigBuilder newDockerBuildConfigBuilderFromDefaults() {
    return new DockerBuildConfigBuilder().withEnabled(true).withDockerFile("Dockerfile").withAutoPushEnabled(false).withAutoBuildEnabled(false).withAutoDeployEnabled(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DockerBuildConfig that = (DockerBuildConfig) o;
    if (!java.util.Objects.equals(autoDeployEnabled, that.autoDeployEnabled)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(autoDeployEnabled,  super.hashCode());
  }
  

}