/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.HelmDependency;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class HelmDependencyFluent<A extends HelmDependencyFluent<A>>
extends BaseFluent<A> {
    private String name;
    private String version;
    private String repository;
    private String condition;
    private List<String> tags = new ArrayList<String>();
    private Boolean enabled;
    private String alias;

    public HelmDependencyFluent() {
    }

    public HelmDependencyFluent(HelmDependency instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HelmDependency instance) {
        HelmDependency helmDependency = instance = instance != null ? instance : new HelmDependency();
        if (instance != null) {
            this.withName(instance.getName());
            this.withVersion(instance.getVersion());
            this.withRepository(instance.getRepository());
            this.withCondition(instance.getCondition());
            this.withTags(instance.getTags());
            this.withEnabled(instance.getEnabled());
            this.withAlias(instance.getAlias());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getRepository() {
        return this.repository;
    }

    public A withRepository(String repository) {
        this.repository = repository;
        return (A)((Object)this);
    }

    public boolean hasRepository() {
        return this.repository != null;
    }

    public String getCondition() {
        return this.condition;
    }

    public A withCondition(String condition) {
        this.condition = condition;
        return (A)((Object)this);
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getTags() {
        int size = this.tags != null ? this.tags.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.tags) {
            result[index++] = item;
        }
        return result;
    }

    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)((Object)this);
    }

    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)((Object)this);
    }

    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTags(String ... items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTags(Collection<String> items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public A withAlias(String alias) {
        this.alias = alias;
        return (A)((Object)this);
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HelmDependencyFluent that = (HelmDependencyFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.repository, that.repository)) {
            return false;
        }
        if (!Objects.equals(this.condition, that.condition)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        return Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.repository, this.condition, this.tags, this.enabled, this.alias, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.repository != null) {
            sb.append("repository:");
            sb.append(this.repository + ",");
        }
        if (this.condition != null) {
            sb.append("condition:");
            sb.append(this.condition + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.alias != null) {
            sb.append("alias:");
            sb.append(this.alias);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }
}

