/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class HelmTarArchiver {
    public static File createTarBall(File outputFile, File inputDirectory, List<File> fileList, String compression, Consumer<TarArchiveEntry> tarArchiveEntryCustomizer) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            TarArchiveOutputStream tarArchiveOutputStream = HelmTarArchiver.isGzip(compression) ? new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)bufferedOutputStream)) : (HelmTarArchiver.isBzip2(compression) ? new TarArchiveOutputStream((OutputStream)new BZip2CompressorOutputStream((OutputStream)bufferedOutputStream)) : new TarArchiveOutputStream((OutputStream)bufferedOutputStream));
            tarArchiveOutputStream.setBigNumberMode(2);
            tarArchiveOutputStream.setLongFileMode(3);
            for (File currentFile : fileList) {
                String relativeFilePath = inputDirectory.toURI().relativize(new File(currentFile.getAbsolutePath()).toURI()).getPath();
                TarArchiveEntry tarEntry = new TarArchiveEntry(currentFile, relativeFilePath);
                tarEntry.setSize(currentFile.length());
                if (currentFile.isDirectory()) {
                    tarEntry.setSize(0L);
                    tarEntry.setMode(16877);
                }
                Optional.ofNullable(tarArchiveEntryCustomizer).ifPresent(tac -> tac.accept(tarEntry));
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
                if (currentFile.isFile()) {
                    try (FileInputStream fis = new FileInputStream(currentFile);){
                        IOUtils.copy((InputStream)fis, (OutputStream)tarArchiveOutputStream);
                    }
                }
                tarArchiveOutputStream.closeArchiveEntry();
            }
            tarArchiveOutputStream.close();
        }
        return outputFile;
    }

    private static boolean isGzip(String compression) {
        return compression.equalsIgnoreCase("tar.gz") || compression.equalsIgnoreCase("tgz");
    }

    private static boolean isBzip2(String compression) {
        return compression.equalsIgnoreCase("tar.bz") || compression.equalsIgnoreCase("tar.bzip2") || compression.equalsIgnoreCase("tar.bz2");
    }
}

