/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.jaeger.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.jaeger.config.Collector;
import io.dekorate.jaeger.config.CollectorFluent;
import io.dekorate.jaeger.config.CollectorFluentImpl;
import io.dekorate.jaeger.config.EditableCollector;

public class CollectorBuilder
extends CollectorFluentImpl<CollectorBuilder>
implements VisitableBuilder<Collector, CollectorBuilder> {
    CollectorFluent<?> fluent;
    Boolean validationEnabled;

    public CollectorBuilder() {
        this(true);
    }

    public CollectorBuilder(Boolean validationEnabled) {
        this(new Collector(), validationEnabled);
    }

    public CollectorBuilder(CollectorFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CollectorBuilder(CollectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Collector(), validationEnabled);
    }

    public CollectorBuilder(CollectorFluent<?> fluent, Collector instance) {
        this(fluent, instance, true);
    }

    public CollectorBuilder(CollectorFluent<?> fluent, Collector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withPort(instance.getPort());
        this.validationEnabled = validationEnabled;
    }

    public CollectorBuilder(Collector instance) {
        this(instance, (Boolean)true);
    }

    public CollectorBuilder(Collector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withPort(instance.getPort());
        this.validationEnabled = validationEnabled;
    }

    public EditableCollector build() {
        EditableCollector buildable = new EditableCollector(this.fluent.getHost(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getPort());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollectorBuilder that = (CollectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

