/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.jaeger.config;

import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.jaeger.config.Collector;
import io.dekorate.jaeger.config.CollectorBuilder;
import io.dekorate.jaeger.config.CollectorFluentImpl;
import io.dekorate.jaeger.config.JaegerAgentConfig;
import io.dekorate.jaeger.config.JaegerAgentConfigFluent;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.PortFluent;
import io.dekorate.kubernetes.config.PortFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JaegerAgentConfigFluentImpl<A extends JaegerAgentConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements JaegerAgentConfigFluent<A> {
    private boolean operatorEnabled = false;
    private String version = "1.10";
    private CollectorBuilder collector = new CollectorBuilder();
    private List<PortBuilder> ports = new ArrayList<PortBuilder>();

    public JaegerAgentConfigFluentImpl() {
    }

    public JaegerAgentConfigFluentImpl(JaegerAgentConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withOperatorEnabled(instance.isOperatorEnabled());
        this.withVersion(instance.getVersion());
        this.withCollector(instance.getCollector());
        this.withPorts(instance.getPorts());
    }

    @Override
    public boolean isOperatorEnabled() {
        return this.operatorEnabled;
    }

    @Override
    public A withOperatorEnabled(boolean operatorEnabled) {
        this.operatorEnabled = operatorEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasOperatorEnabled() {
        return true;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A withNewVersion(String arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuilder arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuffer arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    @Deprecated
    public Collector getCollector() {
        return this.collector != null ? this.collector.build() : null;
    }

    @Override
    public Collector buildCollector() {
        return this.collector != null ? this.collector.build() : null;
    }

    @Override
    public A withCollector(Collector collector) {
        this._visitables.get((Object)"collector").remove(this.collector);
        if (collector != null) {
            this.collector = new CollectorBuilder(collector);
            this._visitables.get((Object)"collector").add(this.collector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCollector() {
        return this.collector != null;
    }

    @Override
    public A withNewCollector(String host, String name, String namespace, int port) {
        return this.withCollector(new Collector(host, name, namespace, port));
    }

    @Override
    public JaegerAgentConfigFluent.CollectorNested<A> withNewCollector() {
        return new CollectorNestedImpl();
    }

    @Override
    public JaegerAgentConfigFluent.CollectorNested<A> withNewCollectorLike(Collector item) {
        return new CollectorNestedImpl(item);
    }

    @Override
    public JaegerAgentConfigFluent.CollectorNested<A> editCollector() {
        return this.withNewCollectorLike(this.getCollector());
    }

    @Override
    public JaegerAgentConfigFluent.CollectorNested<A> editOrNewCollector() {
        return this.withNewCollectorLike(this.getCollector() != null ? this.getCollector() : new CollectorBuilder().build());
    }

    @Override
    public JaegerAgentConfigFluent.CollectorNested<A> editOrNewCollectorLike(Collector item) {
        return this.withNewCollectorLike(this.getCollector() != null ? this.getCollector() : item);
    }

    @Override
    public A withPorts(Port ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Port[] getPorts() {
        int size = this.ports != null ? this.ports.size() : 0;
        Port[] result = new Port[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.ports) {
            result[index++] = (Port)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Port[] buildPorts() {
        int size = this.ports != null ? this.ports.size() : 0;
        Port[] result = new Port[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.ports) {
            result[index++] = (Port)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Port buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        this._visitables.get((Object)"ports").add(index >= 0 ? index : this._visitables.get((Object)"ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"ports").size()) {
            this._visitables.get((Object)"ports").add(builder);
        } else {
            this._visitables.get((Object)"ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Port ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigPorts(Collection<Port> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigPorts(Collection<Port> items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConfigPorts(Predicate<PortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<PortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            PortBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public JaegerAgentConfigFluent.ConfigPortsNested<A> addNewConfigPort() {
        return new ConfigPortsNestedImpl();
    }

    @Override
    public JaegerAgentConfigFluent.ConfigPortsNested<A> addNewPortLike(Port item) {
        return new ConfigPortsNestedImpl(-1, item);
    }

    @Override
    public JaegerAgentConfigFluent.ConfigPortsNested<A> setNewPortLike(int index, Port item) {
        return new ConfigPortsNestedImpl(index, item);
    }

    @Override
    public JaegerAgentConfigFluent.ConfigPortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public JaegerAgentConfigFluent.ConfigPortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public JaegerAgentConfigFluent.ConfigPortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public JaegerAgentConfigFluent.ConfigPortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply((Object)this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JaegerAgentConfigFluentImpl that = (JaegerAgentConfigFluentImpl)o;
        if (this.operatorEnabled != that.operatorEnabled) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.collector != null ? !this.collector.equals(that.collector) : that.collector != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public class ConfigPortsNestedImpl<N>
    extends PortFluentImpl<JaegerAgentConfigFluent.ConfigPortsNested<N>>
    implements JaegerAgentConfigFluent.ConfigPortsNested<N>,
    Nested<N> {
        private final PortBuilder builder;
        private final int index;

        ConfigPortsNestedImpl(int index, Port item) {
            this.index = index;
            this.builder = new PortBuilder((PortFluent)this, item);
        }

        ConfigPortsNestedImpl() {
            this.index = -1;
            this.builder = new PortBuilder((PortFluent)this);
        }

        @Override
        public N and() {
            return (N)JaegerAgentConfigFluentImpl.this.setToPorts(this.index, (Port)this.builder.build());
        }

        @Override
        public N endConfigPort() {
            return this.and();
        }
    }

    public class CollectorNestedImpl<N>
    extends CollectorFluentImpl<JaegerAgentConfigFluent.CollectorNested<N>>
    implements JaegerAgentConfigFluent.CollectorNested<N>,
    Nested<N> {
        private final CollectorBuilder builder;

        CollectorNestedImpl(Collector item) {
            this.builder = new CollectorBuilder(this, item);
        }

        CollectorNestedImpl() {
            this.builder = new CollectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)JaegerAgentConfigFluentImpl.this.withCollector(this.builder.build());
        }

        @Override
        public N endCollector() {
            return this.and();
        }
    }
}

