/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.jaeger.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.jaeger.adapter.JaegerAgentConfigAdapter;
import io.dekorate.jaeger.annotation.EnableJaegerAgent;
import io.dekorate.jaeger.config.AddDefaultPortsToAgentConfigurator;
import io.dekorate.jaeger.config.JaegerAgentConfig;
import io.dekorate.jaeger.config.JaegerAgentConfigBuilder;
import io.dekorate.jaeger.handler.JaegerAgentHandler;
import io.dekorate.kubernetes.config.Configurator;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.Element;

public interface JaegerAgentGenerator
extends Generator,
WithSession {
    default public String getKey() {
        return "jaeger";
    }

    default public Class<? extends Annotation> getAnnotation() {
        return EnableJaegerAgent.class;
    }

    default public void add(Map map) {
        this.on((ConfigurationSupplier<JaegerAgentConfig>)new PropertyConfiguration((VisitableBuilder)JaegerAgentConfigAdapter.newBuilder(this.propertiesMap(map, EnableJaegerAgent.class))));
    }

    default public void add(Element element) {
        EnableJaegerAgent serviceMonitor = element.getAnnotation(EnableJaegerAgent.class);
        this.on((ConfigurationSupplier<JaegerAgentConfig>)(serviceMonitor != null ? new AnnotationConfiguration((VisitableBuilder)JaegerAgentConfigAdapter.newBuilder(serviceMonitor)) : new AnnotationConfiguration((VisitableBuilder)new JaegerAgentConfigBuilder())));
    }

    default public void on(ConfigurationSupplier<JaegerAgentConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
        session.configurators().add((Configurator)new AddDefaultPortsToAgentConfigurator());
        session.handlers().add(new JaegerAgentHandler(session.resources()));
    }
}

