/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.jaeger.handler;

import io.dekorate.Handler;
import io.dekorate.Resources;
import io.dekorate.jaeger.config.Collector;
import io.dekorate.jaeger.config.EditableJaegerAgentConfig;
import io.dekorate.jaeger.config.JaegerAgentConfig;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AnnotationBuilder;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluent;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Strings;

public class JaegerAgentHandler
implements Handler<JaegerAgentConfig> {
    private final Resources resources;

    public JaegerAgentHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 460;
    }

    public void handle(JaegerAgentConfig config) {
        if (config.isOperatorEnabled()) {
            this.resources.decorate((Decorator)new AddAnnotationDecorator((Annotation)((AnnotationBuilder)((AnnotationBuilder)new AnnotationBuilder().withKey("sidecar.jaegertracing.io/inject")).withValue("true")).build()));
        } else {
            ContainerBuilder builder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("jaeger-agent")).withImage("jaegertracing/jaeger-agent:" + config.getVersion())).withArguments(new String[]{"--collector.host-port=" + JaegerAgentHandler.collectorHostPort(config)});
            for (Port port : config.getPorts()) {
                builder = (ContainerBuilder)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)builder.addNewPort().withName(port.getName())).withHostPort(port.getHostPort() > 0 ? port.getHostPort() : 0)).withContainerPort(port.getContainerPort())).withProtocol(port.getProtocol() != null ? port.getProtocol() : Protocol.TCP)).endPort();
            }
            this.resources.decorate((Decorator)new AddSidecarDecorator((Container)builder.build()));
        }
    }

    private static String collectorHostPort(JaegerAgentConfig config) {
        StringBuilder sb = new StringBuilder();
        Collector collector = config.getCollector();
        if (Strings.isNotNullOrEmpty((String)collector.getHost())) {
            sb.append(collector.getHost());
        } else {
            sb.append(collector.getName());
            if (Strings.isNotNullOrEmpty((String)collector.getNamespace())) {
                sb.append(".").append(collector.getNamespace());
            }
            sb.append("svc");
        }
        sb.append(":");
        sb.append(collector.getPort());
        return sb.toString();
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(JaegerAgentConfig.class) || type.equals(EditableJaegerAgentConfig.class);
    }
}

