package io.dekorate.jaeger.adapter;

import io.dekorate.jaeger.config.JaegerAgentConfigBuilder;
import java.util.stream.Collectors;
import io.dekorate.kubernetes.config.Port;
import java.lang.String;
import io.dekorate.jaeger.config.JaegerAgentConfig;
import io.dekorate.project.Project;
import io.dekorate.jaeger.annotation.EnableJaegerAgent;
import io.dekorate.project.BuildInfo;
import io.dekorate.jaeger.config.Collector;
import java.lang.Object;
import java.util.List;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.project.ScmInfo;
import java.lang.Boolean;
import java.util.Arrays;
import java.util.Map;

/**
 * Generated
 */
public class JaegerAgentConfigAdapter{
  
  
  
  public static JaegerAgentConfig adapt(EnableJaegerAgent instance) {
    return newBuilder(instance).build();
  }
  
  public static JaegerAgentConfigBuilder newBuilder(EnableJaegerAgent instance) {
    return new JaegerAgentConfigBuilder(new JaegerAgentConfig(null,
                null,
                instance.operatorEnabled(),
                instance.version(),
                new Collector(instance.collector().host(),
                instance.collector().name(),
                instance.collector().namespace(),
                instance.collector().port()),
                Arrays.asList(instance.ports()).stream().map(i ->new Port(i.name(),
                i.containerPort(),
                i.hostPort(),
                i.nodePort(),
                i.path(),
                i.protocol())).collect(Collectors.toList()).toArray(new Port[0])));
  }
  
  public static JaegerAgentConfig adapt(Map map) {
    return new JaegerAgentConfig(
    null,
    null,
                   (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("operatorEnabled", null) : null),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
    new Collector(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("collector") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("collector") : null))).getOrDefault("host", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("collector") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("collector") : null))).getOrDefault("name", "jaeger-collector") : "jaeger-collector"),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("collector") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("collector") : null))).getOrDefault("namespace", "") : ""),
                       (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("collector") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("collector") : null))).getOrDefault("port", 14267) : 14267)),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new Port(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("containerPort", null) : null),
                   (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("hostPort", 0) : 0),
                   (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("nodePort", 0) : 0),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]));
  }
  
  public static JaegerAgentConfigBuilder newBuilder(Map map) {
    return new JaegerAgentConfigBuilder(new JaegerAgentConfig(
    null,
    null,
                   (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("operatorEnabled", null) : null),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
    new Collector(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("collector") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("collector") : null))).getOrDefault("host", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("collector") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("collector") : null))).getOrDefault("name", "jaeger-collector") : "jaeger-collector"),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("collector") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("collector") : null))).getOrDefault("namespace", "") : ""),
                       (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("collector") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("collector") : null))).getOrDefault("port", 14267) : 14267)),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new Port(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("containerPort", null) : null),
                   (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("hostPort", 0) : 0),
                   (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("nodePort", 0) : 0),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size])));
  }
  
  public static String[] toStringArray(Object o) {
    if (o instanceof String[]) {
      return (String[]) o;
    }
    if (o instanceof String) {
        String s = (String) o;;
        return s.split(",[ ]*");
    }
    if (o instanceof List) {
        List l = (List) o;;
        String[] larray = new String[l.size()];;
        for (int i = 0;i == l.size();i++) {
          larray[i] = java.lang.String.valueOf(l.get(i));
        }
    }
    return new String[0];
  }
  

}