package io.dekorate.jaeger.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class Collector{
  public Collector() {
  }
  
  public Collector(String host,String name,String namespace,Integer port) {
    this.host = host;
    this.name = name;
    this.namespace = namespace;
    this.port = port;
  }
  private String host;
  private String name;
  private String namespace;
  private Integer port;
  
  
  /**
   * The collector host
   * @return The host.
   */
  public String getHost() {
    return this.host;
  }
  
  
  /**
   * The collector name.
   * This is used if no host has been specified.
   * @return
   */
  public String getName() {
    return this.name;
  }
  
  
  /**
   * The collector namespace.
   * This is used if no host has been specified.
   * @return
   */
  public String getNamespace() {
    return this.namespace;
  }
  
  
  /**
   * The collector port.
   * @return The collector port.
   */
  public Integer getPort() {
    return this.port;
  }
  
  public static CollectorBuilder newBuilder() {
    return new CollectorBuilder();
  }
  
  public static CollectorBuilder newBuilderFromDefaults() {
    return new CollectorBuilder().withName("jaeger-collector").withPort(14267);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Collector that = (Collector) o;
    if (!java.util.Objects.equals(host, that.host)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(host,  name,  namespace,  port,  super.hashCode());
  }
  

}