package io.dekorate.jaeger.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Port;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class JaegerAgentConfig extends Configuration{
  public JaegerAgentConfig() {
  }
  
  public JaegerAgentConfig(Project project,Map<ConfigKey,Object> attributes,Boolean operatorEnabled,String version,Collector collector,Port[] ports) {
    super(project, attributes);
    this.operatorEnabled = operatorEnabled;
    this.version = version;
    this.collector = collector;
    this.ports = ports != null ? ports : new Port[0];
  }
  private Boolean operatorEnabled;
  private String version;
  private Collector collector;
  private Port[] ports = new Port[0];
  
  
  /**
   * Flag to specify if Jaeger operator is available / enabled.
   * @return True, if operator is available / enabled.
   */
  public Boolean getOperatorEnabled() {
    return this.operatorEnabled;
  }
  
  
  /**
   * Flag to specify if Jaeger operator is available / enabled.
   * @return True, if operator is available / enabled.
   */
  public boolean isOperatorEnabled() {
    return this.operatorEnabled != null &&  this.operatorEnabled;
  }
  
  
  /**
   * The jaeger agent version.
   * @return The version, or default to 1.10
   */
  public String getVersion() {
    return this.version;
  }
  
  public Collector getCollector() {
    return this.collector;
  }
  
  public Port[] getPorts() {
    return this.ports;
  }
  
  public static JaegerAgentConfigBuilder newJaegerAgentConfigBuilder() {
    return new JaegerAgentConfigBuilder();
  }
  
  public static JaegerAgentConfigBuilder newJaegerAgentConfigBuilderFromDefaults() {
    return new JaegerAgentConfigBuilder().withOperatorEnabled(false).withVersion("1.10");
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JaegerAgentConfig that = (JaegerAgentConfig) o;
    if (!java.util.Objects.equals(operatorEnabled, that.operatorEnabled)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(collector, that.collector)) return false;
    if (!java.util.Objects.equals(ports, that.ports)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(operatorEnabled,  version,  collector,  ports,  super.hashCode());
  }
  

}