package io.dekorate.jaeger.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.dekorate.kubernetes.config.Port;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.dekorate.kubernetes.config.PortFluent;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.dekorate.kubernetes.config.PortBuilder;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JaegerAgentConfigFluent<A extends JaegerAgentConfigFluent<A>> extends ConfigurationFluent<A>{
  public JaegerAgentConfigFluent() {
  }
  
  public JaegerAgentConfigFluent(JaegerAgentConfig instance) {
    this.copyInstance(instance);
  }
  private Boolean operatorEnabled;
  private String version;
  private CollectorBuilder collector;
  private ArrayList<PortBuilder> ports = new ArrayList<PortBuilder>();
  
  protected void copyInstance(JaegerAgentConfig instance) {
    instance = (instance != null ? instance : new JaegerAgentConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withOperatorEnabled(instance.getOperatorEnabled());
          this.withVersion(instance.getVersion());
          this.withCollector(instance.getCollector());
          this.withPorts(instance.getPorts());
        }
  }
  
  public Boolean getOperatorEnabled() {
    return this.operatorEnabled;
  }
  
  public A withOperatorEnabled(Boolean operatorEnabled) {
    this.operatorEnabled = operatorEnabled;
    return (A) this;
  }
  
  public boolean hasOperatorEnabled() {
    return this.operatorEnabled != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public Collector buildCollector() {
    return this.collector != null ? this.collector.build() : null;
  }
  
  public A withCollector(Collector collector) {
    this._visitables.remove("collector");
    if (collector != null) {
        this.collector = new CollectorBuilder(collector);
        this._visitables.get("collector").add(this.collector);
    } else {
        this.collector = null;
        this._visitables.get("collector").remove(this.collector);
    }
    return (A) this;
  }
  
  public boolean hasCollector() {
    return this.collector != null;
  }
  
  public A withNewCollector(String host,String name,String namespace,Integer port) {
    return (A)withCollector(new Collector(host, name, namespace, port));
  }
  
  public CollectorNested<A> withNewCollector() {
    return new CollectorNested(null);
  }
  
  public CollectorNested<A> withNewCollectorLike(Collector item) {
    return new CollectorNested(item);
  }
  
  public CollectorNested<A> editCollector() {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(null));
  }
  
  public CollectorNested<A> editOrNewCollector() {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(new CollectorBuilder().build()));
  }
  
  public CollectorNested<A> editOrNewCollectorLike(Collector item) {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(item));
  }
  
  public A withPorts(io.dekorate.kubernetes.config.Port... ports) {
    if (this.ports != null) {
        this.ports.clear();
        _visitables.remove("ports");
    }
    if (ports != null) {
      for (Port item : ports) {
        this.addToPorts(item);
      }
    }
    return (A) this;
  }
  
  public Port[] buildPorts() {
    int size = ports != null ? ports.size() : 0;;
    Port[] result = new Port[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Port,PortBuilder> item : ports) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Port buildPort(int index) {
    return this.ports.get(index).build();
  }
  
  public Port buildFirstPort() {
    return this.ports.get(0).build();
  }
  
  public Port buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  
  public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
      for (PortBuilder item : ports) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
      for (PortBuilder item : ports) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToPorts(int index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").add(index, builder); ports.add(index, builder);}
    return (A)this;
  }
  
  public A setToPorts(int index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").set(index, builder); ports.set(index, builder);}
    return (A)this;
  }
  
  public A addToPorts(io.dekorate.kubernetes.config.Port... items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  
  public A addAllToPorts(Collection<Port> items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  
  public A removeFromPorts(io.dekorate.kubernetes.config.Port... items) {
    if (this.ports == null) return (A)this;
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPorts(Collection<Port> items) {
    if (this.ports == null) return (A)this;
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<PortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      PortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasPorts() {
    return this.ports != null && !this.ports.isEmpty();
  }
  
  public PortsNested<A> addNewPort() {
    return new PortsNested(-1, null);
  }
  
  public PortsNested<A> addNewPortLike(Port item) {
    return new PortsNested(-1, item);
  }
  
  public PortsNested<A> setNewPortLike(int index,Port item) {
    return new PortsNested(index, item);
  }
  
  public PortsNested<A> editPort(int index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  
  public PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JaegerAgentConfigFluent that = (JaegerAgentConfigFluent) o;
    if (!java.util.Objects.equals(operatorEnabled, that.operatorEnabled)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(collector, that.collector)) return false;
    if (!java.util.Objects.equals(ports, that.ports)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(operatorEnabled,  version,  collector,  ports,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (operatorEnabled != null) { sb.append("operatorEnabled:"); sb.append(operatorEnabled + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (collector != null) { sb.append("collector:"); sb.append(collector + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withOperatorEnabled() {
    return withOperatorEnabled(true);
  }
  public class CollectorNested<N> extends CollectorFluent<CollectorNested<N>> implements Nested<N>{
    CollectorNested(Collector item) {
      this.builder = new CollectorBuilder(this, item);
    }
    CollectorBuilder builder;
    
    public N and() {
      return (N) JaegerAgentConfigFluent.this.withCollector(builder.build());
    }
    
    public N endCollector() {
      return and();
    }
    
  
  }
  public class PortsNested<N> extends PortFluent<PortsNested<N>> implements Nested<N>{
    PortsNested(int index,Port item) {
      this.index = index;
      this.builder = new PortBuilder(this, item);
    }
    PortBuilder builder;
    int index;
    
    public N and() {
      return (N) JaegerAgentConfigFluent.this.setToPorts(index,builder.build());
    }
    
    public N endPort() {
      return and();
    }
    
  
  }

}