/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.jib.buildservice;

import io.dekorate.BuildService;
import io.dekorate.DekorateException;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.jib.config.JibBuildConfig;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.utils.Exec;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class JibBuildService
implements BuildService {
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final String JIB_VERSION = "3.1.4";
    private final String BUILD = "build";
    private final String DOCKER_BUILD = "dockerBuild";
    private final String MAVEN_GOAL = "com.google.cloud.tools:jib-maven-plugin:%s:%s";
    private final String JIB = "jib";
    private final String JIB_DOCKER_BUILD = "jibDockerBuild";
    private final String GRADLE_INIT = "--";
    private final Project project;
    private final ImageConfiguration config;
    private final String image;
    private final Exec.ProjectExec exec;

    public JibBuildService(Project project, ImageConfiguration config) {
        this.project = project;
        this.exec = Exec.inProject((Project)project);
        this.image = Images.getImage((String)(Strings.isNullOrEmpty((String)config.getRegistry()) ? "docker.io" : config.getRegistry()), (String)config.getGroup(), (String)config.getName(), (String)config.getVersion());
        this.config = config;
    }

    public void build() {
        this.LOGGER.info("Performing jib build.");
        if (this.project.getBuildInfo().getBuildTool().equals("maven")) {
            this.mavenBuild();
        }
    }

    public void push() {
        if (JibBuildService.isDockerBuildEnabled(this.config)) {
            this.exec.commands(new String[]{"docker", "push", this.image});
        }
    }

    private void mavenBuild() {
        this.exec.commands(new String[]{"mvn", "compile", String.format("com.google.cloud.tools:jib-maven-plugin:%s:%s", "3.1.4", JibBuildService.isDockerBuildEnabled(this.config) ? "dockerBuild" : "build"), "-Djib.to.image=" + this.image});
    }

    private void gradleBuild() {
        Path outputPath = null;
        String content = null;
        URL url = this.getClass().getClassLoader().getResource("init.gradle");
        try (InputStream is = url.openStream();){
            content = Strings.read((InputStream)is);
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((String)"Error reading init.gradle from resources.", (Throwable)e);
        }
        try {
            outputPath = Files.createTempFile("dekorate", "init-gradle", new FileAttribute[0]);
            Files.write(outputPath, content.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((String)"Error writing init.gradle to tmp.", (Throwable)e);
        }
        this.exec.commands(new String[]{"gradle", JibBuildService.isDockerBuildEnabled(this.config) ? "jibDockerBuild" : "jib", "--init-script", outputPath.toAbsolutePath().toString()});
    }

    private static boolean isDockerBuildEnabled(ImageConfiguration config) {
        if (!(config instanceof JibBuildConfig)) {
            return true;
        }
        JibBuildConfig jibConfig = (JibBuildConfig)config;
        return jibConfig.isDockerBuild();
    }
}

