/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.jib.buildservice;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceApplicablility;
import io.dekorate.BuildServiceFactory;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.jib.buildservice.JibBuildService;
import io.dekorate.jib.config.JibBuildConfig;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class JibBuildServiceFactory
implements BuildServiceFactory {
    private static final List<String> SUPPORTED_TOOLS = Arrays.asList("maven");
    private static final String JIB = "jib";

    public String name() {
        return JIB;
    }

    public int order() {
        return 15;
    }

    public BuildServiceApplicablility checkApplicablility(Project project, ImageConfiguration config) {
        if (!(config instanceof JibBuildConfig)) {
            return new BuildServiceApplicablility(false, "Jib build config not found");
        }
        JibBuildConfig buildConfig = (JibBuildConfig)config;
        if (!buildConfig.isEnabled()) {
            return new BuildServiceApplicablility(false, "Project build tool is disabled by Jib");
        }
        if (!SUPPORTED_TOOLS.contains(project.getBuildInfo().getBuildTool())) {
            return new BuildServiceApplicablility(false, "Project build tool no support by Jib");
        }
        return new BuildServiceApplicablility(true, "ok");
    }

    public BuildService create(Project project, ImageConfiguration config) {
        return new JibBuildService(project, config);
    }

    public BuildService create(Project project, ImageConfiguration config, Collection<HasMetadata> resources) {
        return new JibBuildService(project, config);
    }

    public BuildServiceApplicablility checkApplicablility(Project project, ConfigurationSupplier<ImageConfiguration> supplier) {
        if (supplier.isExplicit()) {
            return new BuildServiceApplicablility(true, "Jib has been explicitly configured!");
        }
        return this.checkApplicablility(project, (ImageConfiguration)supplier.get());
    }
}

