package io.dekorate.kind.config;

import java.lang.SuppressWarnings;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KindConfigFluent<A extends KindConfigFluent<A>> extends BaseConfigFluent<A>{
  public KindConfigFluent() {
  }
  
  public KindConfigFluent(KindConfig instance) {
    this.copyInstance(instance);
  }
  private Boolean enabled;
  
  protected void copyInstance(KindConfig instance) {
    instance = (instance != null ? instance : new KindConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withPartOf(instance.getPartOf());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withDeploymentKind(instance.getDeploymentKind());
          this.withLabels(instance.getLabels());
          this.withAnnotations(instance.getAnnotations());
          this.withEnvVars(instance.getEnvVars());
          this.withWorkingDir(instance.getWorkingDir());
          this.withCommand(instance.getCommand());
          this.withArguments(instance.getArguments());
          this.withServiceAccount(instance.getServiceAccount());
          this.withPorts(instance.getPorts());
          this.withServiceType(instance.getServiceType());
          this.withPvcVolumes(instance.getPvcVolumes());
          this.withSecretVolumes(instance.getSecretVolumes());
          this.withConfigMapVolumes(instance.getConfigMapVolumes());
          this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
          this.withGitRepoVolumes(instance.getGitRepoVolumes());
          this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
          this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
          this.withAzureFileVolumes(instance.getAzureFileVolumes());
          this.withMounts(instance.getMounts());
          this.withImagePullPolicy(instance.getImagePullPolicy());
          this.withImagePullSecrets(instance.getImagePullSecrets());
          this.withDeploymentStrategy(instance.getDeploymentStrategy());
          this.withRollingUpdate(instance.getRollingUpdate());
          this.withHostAliases(instance.getHostAliases());
          this.withNodeSelector(instance.getNodeSelector());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withStartupProbe(instance.getStartupProbe());
          this.withRequestResources(instance.getRequestResources());
          this.withLimitResources(instance.getLimitResources());
          this.withSidecars(instance.getSidecars());
          this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
          this.withJobs(instance.getJobs());
          this.withCronJobs(instance.getCronJobs());
          this.withEnabled(instance.getEnabled());
        }
  }
  
  public Boolean getEnabled() {
    return this.enabled;
  }
  
  public A withEnabled(Boolean enabled) {
    this.enabled = enabled;
    return (A) this;
  }
  
  public boolean hasEnabled() {
    return this.enabled != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KindConfigFluent that = (KindConfigFluent) o;
    if (!java.util.Objects.equals(enabled, that.enabled)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(enabled,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (enabled != null) { sb.append("enabled:"); sb.append(enabled); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnabled() {
    return withEnabled(true);
  }
  

}