/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.handler;

import io.dekorate.AbstractKubernetesHandler;
import io.dekorate.BuildServiceFactories;
import io.dekorate.Configurators;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.knative.serving.v1.RevisionSpecFluent;
import io.dekorate.deps.knative.serving.v1.RevisionTemplateSpecFluent;
import io.dekorate.deps.knative.serving.v1.Service;
import io.dekorate.deps.knative.serving.v1.ServiceBuilder;
import io.dekorate.deps.knative.serving.v1.ServiceFluent;
import io.dekorate.deps.knative.serving.v1.ServiceSpecFluent;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.knative.config.EditableKnativeConfig;
import io.dekorate.knative.config.KnativeConfig;
import io.dekorate.knative.config.KnativeConfigBuilder;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Images;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Strings;
import java.util.Optional;

public class KnativeHandler
extends AbstractKubernetesHandler<KnativeConfig>
implements HandlerFactory,
WithProject {
    private static final String KNATIVE = "knative";
    private static final String DEFAULT_REGISTRY = "dev.local/";
    private final Configurators configurators;

    public KnativeHandler() {
        this(new Resources(), new Configurators());
    }

    public KnativeHandler(Resources resources, Configurators configurators) {
        super(resources);
        this.configurators = configurators;
    }

    public Handler create(Resources resources, Configurators configurators) {
        return new KnativeHandler(resources, configurators);
    }

    public int order() {
        return 400;
    }

    public void handle(KnativeConfig config) {
        Optional<Service> existingService = this.resources.groups().getOrDefault(KNATIVE, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof Service).map(i -> (Service)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingService.isPresent()) {
            this.resources.add(KNATIVE, (HasMetadata)this.createService(config));
        }
        this.addDecorators(KNATIVE, config);
    }

    public ConfigurationSupplier<KnativeConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((KnativeConfigBuilder)new KnativeConfigBuilder().accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(p)));
    }

    protected void addDecorators(String group, KnativeConfig config) {
        super.addDecorators(group, (BaseConfig)config);
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(KnativeConfig.class) || type.equals(EditableKnativeConfig.class);
    }

    public Service createService(KnativeConfig config) {
        ImageConfiguration imageConfig = KnativeHandler.getImageConfiguration(this.getProject(), config, this.configurators);
        String image = Strings.isNotNullOrEmpty((String)imageConfig.getImage()) ? imageConfig.getImage() : Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.TemplateNested)((RevisionTemplateSpecFluent.SpecNested)((RevisionSpecFluent.ContainersNested)((RevisionSpecFluent.ContainersNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(config.getName())).withLabels(Labels.createLabels((BaseConfig)config))).endMetadata()).withNewSpec().withNewTemplate().withNewSpec().addNewContainer().withName(config.getName())).withImage(image)).endContainer()).endSpec()).endTemplate()).endSpec()).build();
    }

    private static ImageConfiguration getImageConfiguration(Project project, KnativeConfig config, Configurators configurators) {
        return configurators.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> KnativeHandler.merge(config, i)).orElse(ImageConfiguration.from((ApplicationConfiguration)config));
    }

    private static ImageConfiguration merge(KnativeConfig config, ImageConfiguration imageConfig) {
        if (config == null) {
            throw new NullPointerException("KnativeConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from((ApplicationConfiguration)config);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : config.getProject())).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : null)).withName(imageConfig.getName() != null ? imageConfig.getName() : config.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : config.getVersion())).withRegistry(imageConfig.getRegistry() != null ? imageConfig.getRegistry() : null)).withDockerFile(imageConfig.getDockerFile() != null ? imageConfig.getDockerFile() : null)).withAutoBuildEnabled(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false)).withAutoPushEnabled(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false)).build();
    }
}

