/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.handler;

import io.dekorate.AbstractKubernetesHandler;
import io.dekorate.BuildServiceFactories;
import io.dekorate.Configurators;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.knative.serving.v1.RevisionSpecFluent;
import io.dekorate.deps.knative.serving.v1.RevisionTemplateSpecFluent;
import io.dekorate.deps.knative.serving.v1.Service;
import io.dekorate.deps.knative.serving.v1.ServiceBuilder;
import io.dekorate.deps.knative.serving.v1.ServiceFluent;
import io.dekorate.deps.knative.serving.v1.ServiceSpecFluent;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.knative.config.AutoScalerClass;
import io.dekorate.knative.config.AutoscalingMetric;
import io.dekorate.knative.config.EditableKnativeConfig;
import io.dekorate.knative.config.GlobalAutoScaling;
import io.dekorate.knative.config.KnativeConfig;
import io.dekorate.knative.config.KnativeConfigBuilder;
import io.dekorate.knative.decorator.ApplyGlobalAutoscalingClassDecorator;
import io.dekorate.knative.decorator.ApplyGlobalContainerConcurrencyDecorator;
import io.dekorate.knative.decorator.ApplyGlobalRequestsPerSecondTargetDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingClassDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingMetricDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingTargetDecorator;
import io.dekorate.knative.decorator.ApplyLocalContainerConcurrencyDecorator;
import io.dekorate.knative.decorator.ApplyMaxScaleDecorator;
import io.dekorate.knative.decorator.ApplyMinScaleDecorator;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelBuilder;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddConfigMapDataDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapResourceProvidingDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.ApplyPortNameDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Images;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import java.util.Optional;

public class KnativeHandler
extends AbstractKubernetesHandler<KnativeConfig>
implements HandlerFactory,
WithProject {
    private static final String KNATIVE = "knative";
    private static final String DEFAULT_REGISTRY = "dev.local/";
    private static final String KNATIVE_VISIBILITY = "serving.knative.dev/visibility";
    private static final String CLUSTER_LOCAL = "cluster-local";
    private final Configurators configurators;

    public KnativeHandler() {
        this(new Resources(), new Configurators());
    }

    public KnativeHandler(Resources resources, Configurators configurators) {
        super(resources);
        this.configurators = configurators;
    }

    public Handler create(Resources resources, Configurators configurators) {
        return new KnativeHandler(resources, configurators);
    }

    public int order() {
        return 400;
    }

    public void handle(KnativeConfig config) {
        Optional<Service> existingService = this.resources.groups().getOrDefault(KNATIVE, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof Service).map(i -> (Service)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingService.isPresent()) {
            this.resources.add(KNATIVE, (HasMetadata)this.createService(config));
        }
        this.resources.decorate(KNATIVE, (Decorator)new ApplyPortNameDecorator(null, null, config.getHttpTransportVersion().name().toLowerCase(), Ports.HTTP_PORT_NAMES.toArray(new String[Ports.HTTP_PORT_NAMES.size()])));
        this.addDecorators(KNATIVE, config);
        if (config.getRevisionAutoScaling().getMetric() != AutoscalingMetric.concurrency) {
            this.resources.decorate(KNATIVE, (Decorator)new ApplyLocalAutoscalingMetricDecorator(config.getName(), config.getRevisionAutoScaling().getMetric()));
        }
        if (config.getRevisionAutoScaling().getContainerConcurrency() != 0) {
            this.resources.decorate(KNATIVE, (Decorator)new ApplyLocalContainerConcurrencyDecorator(config.getName(), config.getRevisionAutoScaling().getContainerConcurrency()));
        }
        if (config.getRevisionAutoScaling().getAutoScalerClass() != AutoScalerClass.kpa) {
            this.resources.decorate(KNATIVE, (Decorator)new ApplyLocalAutoscalingClassDecorator(config.getName(), config.getRevisionAutoScaling().getAutoScalerClass()));
        }
        if (config.getRevisionAutoScaling().getTarget() != 0) {
            this.resources.decorate(KNATIVE, (Decorator)new ApplyLocalAutoscalingTargetDecorator(config.getName(), config.getRevisionAutoScaling().getTarget()));
        }
        if (config.getRevisionAutoScaling().getTarget() != 200 && config.getRevisionAutoScaling().getMetric() == AutoscalingMetric.rps) {
            this.resources.decorate(KNATIVE, (Decorator)new ApplyLocalContainerConcurrencyDecorator(config.getName(), config.getRevisionAutoScaling().getTarget()));
        }
        if (config.getRevisionAutoScaling().getTargetUtilizationPercentage() != 70) {
            this.resources.decorate(KNATIVE, (Decorator)new ApplyLocalContainerConcurrencyDecorator(config.getName(), config.getRevisionAutoScaling().getTargetUtilizationPercentage()));
        }
        if (config.getMinScale() != 0) {
            this.resources.decorate(KNATIVE, (Decorator)new ApplyMinScaleDecorator(config.getName(), config.getMinScale()));
        }
        if (config.getMaxScale() != 0) {
            this.resources.decorate(KNATIVE, (Decorator)new ApplyMaxScaleDecorator(config.getName(), config.getMaxScale()));
        }
        if (!KnativeHandler.isDefault(config.getGlobalAutoScaling())) {
            this.resources.decorate(KNATIVE, (Decorator)new AddConfigMapResourceProvidingDecorator("config-autoscaler"));
            if (config.getGlobalAutoScaling().getAutoScalerClass() != AutoScalerClass.kpa) {
                this.resources.decorate(KNATIVE, (Decorator)new ApplyGlobalAutoscalingClassDecorator(config.getGlobalAutoScaling().getAutoScalerClass()));
            }
            if (config.getGlobalAutoScaling().getRequestsPerSecond() != 200) {
                this.resources.decorate(KNATIVE, (Decorator)new ApplyGlobalRequestsPerSecondTargetDecorator(config.getGlobalAutoScaling().getRequestsPerSecond()));
            }
            if (config.getGlobalAutoScaling().getTargetUtilizationPercentage() != 70) {
                this.resources.decorate(KNATIVE, (Decorator)new ApplyGlobalContainerConcurrencyDecorator(config.getGlobalAutoScaling().getTargetUtilizationPercentage()));
            }
        }
        if (config.getGlobalAutoScaling().getContainerConcurrency() != 0) {
            this.resources.decorate(KNATIVE, (Decorator)new AddConfigMapResourceProvidingDecorator("config-defaults"));
            this.resources.decorate(KNATIVE, (Decorator)new ApplyGlobalContainerConcurrencyDecorator(config.getGlobalAutoScaling().getContainerConcurrency()));
        }
        if (!config.isScaleToZeroEnabled()) {
            this.resources.decorate(KNATIVE, (Decorator)new AddConfigMapResourceProvidingDecorator("config-autoscaler"));
            this.resources.decorate(KNATIVE, (Decorator)new AddConfigMapDataDecorator("config-autoscaler", new String[]{"enable-scale-to-zero", String.valueOf(config.isAutoDeployEnabled())}));
        }
    }

    public ConfigurationSupplier<KnativeConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((KnativeConfigBuilder)new KnativeConfigBuilder().accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(p)));
    }

    protected void addDecorators(String group, KnativeConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        if (!config.isExpose()) {
            this.resources.decorate(group, (Decorator)new AddLabelDecorator(config.getName(), (Label)((LabelBuilder)((LabelBuilder)new LabelBuilder().withKey(KNATIVE_VISIBILITY)).withValue(CLUSTER_LOCAL)).build()));
        }
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(KnativeConfig.class) || type.equals(EditableKnativeConfig.class);
    }

    public Service createService(KnativeConfig config) {
        ImageConfiguration imageConfig = KnativeHandler.getImageConfiguration(this.getProject(), config, this.configurators);
        String image = Strings.isNotNullOrEmpty((String)imageConfig.getImage()) ? imageConfig.getImage() : Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.TemplateNested)((RevisionTemplateSpecFluent.SpecNested)((RevisionSpecFluent.ContainersNested)((RevisionSpecFluent.ContainersNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(config.getName())).endMetadata()).withNewSpec().withNewTemplate().withNewSpec().addNewContainer().withName(config.getName())).withImage(image)).endContainer()).endSpec()).endTemplate()).endSpec()).build();
    }

    public static boolean isDefault(GlobalAutoScaling autoScaling) {
        if (autoScaling.getAutoScalerClass() != AutoScalerClass.kpa) {
            return false;
        }
        if (autoScaling.getContainerConcurrency() != 0) {
            return false;
        }
        if (autoScaling.getRequestsPerSecond() != 200) {
            return false;
        }
        return autoScaling.getTargetUtilizationPercentage() == 70;
    }

    private static ImageConfiguration getImageConfiguration(Project project, KnativeConfig config, Configurators configurators) {
        return configurators.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> KnativeHandler.merge(config, i)).orElse(ImageConfiguration.from((ApplicationConfiguration)config));
    }

    private static ImageConfiguration merge(KnativeConfig config, ImageConfiguration imageConfig) {
        if (config == null) {
            throw new NullPointerException("KnativeConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from((ApplicationConfiguration)config);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : config.getProject())).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : null)).withName(imageConfig.getName() != null ? imageConfig.getName() : config.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : config.getVersion())).withRegistry(imageConfig.getRegistry() != null ? imageConfig.getRegistry() : null)).withDockerFile(imageConfig.getDockerFile() != null ? imageConfig.getDockerFile() : null)).withAutoBuildEnabled(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false)).withAutoPushEnabled(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false)).build();
    }
}

