/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.knative.config.AutoScaling;
import io.dekorate.knative.config.AutoScalingBuilder;
import io.dekorate.knative.config.AutoScalingFluentImpl;
import io.dekorate.knative.config.GlobalAutoScaling;
import io.dekorate.knative.config.GlobalAutoScalingBuilder;
import io.dekorate.knative.config.GlobalAutoScalingFluentImpl;
import io.dekorate.knative.config.HttpTransportVersion;
import io.dekorate.knative.config.KnativeConfig;
import io.dekorate.knative.config.KnativeConfigFluent;
import io.dekorate.kubernetes.config.BaseConfigFluentImpl;

public class KnativeConfigFluentImpl<A extends KnativeConfigFluent<A>>
extends BaseConfigFluentImpl<A>
implements KnativeConfigFluent<A> {
    private HttpTransportVersion httpTransportVersion = HttpTransportVersion.HTTP1;
    private int minScale = 0;
    private int maxScale = 0;
    private boolean scaleToZeroEnabled = true;
    private AutoScalingBuilder revisionAutoScaling = new AutoScalingBuilder();
    private GlobalAutoScalingBuilder globalAutoScaling = new GlobalAutoScalingBuilder();

    public KnativeConfigFluentImpl() {
    }

    public KnativeConfigFluentImpl(KnativeConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withServiceAccount(instance.getServiceAccount());
        this.withHost(instance.getHost());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withSidecars(instance.getSidecars());
        this.withExpose(instance.isExpose());
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled());
        this.withHttpTransportVersion(instance.getHttpTransportVersion());
        this.withMinScale(instance.getMinScale());
        this.withMaxScale(instance.getMaxScale());
        this.withScaleToZeroEnabled(instance.isScaleToZeroEnabled());
        this.withRevisionAutoScaling(instance.getRevisionAutoScaling());
        this.withGlobalAutoScaling(instance.getGlobalAutoScaling());
    }

    @Override
    public HttpTransportVersion getHttpTransportVersion() {
        return this.httpTransportVersion;
    }

    @Override
    public A withHttpTransportVersion(HttpTransportVersion httpTransportVersion) {
        this.httpTransportVersion = httpTransportVersion;
        return (A)this;
    }

    @Override
    public Boolean hasHttpTransportVersion() {
        return this.httpTransportVersion != null;
    }

    @Override
    public int getMinScale() {
        return this.minScale;
    }

    @Override
    public A withMinScale(int minScale) {
        this.minScale = minScale;
        return (A)this;
    }

    @Override
    public Boolean hasMinScale() {
        return true;
    }

    @Override
    public int getMaxScale() {
        return this.maxScale;
    }

    @Override
    public A withMaxScale(int maxScale) {
        this.maxScale = maxScale;
        return (A)this;
    }

    @Override
    public Boolean hasMaxScale() {
        return true;
    }

    @Override
    public boolean isScaleToZeroEnabled() {
        return this.scaleToZeroEnabled;
    }

    @Override
    public A withScaleToZeroEnabled(boolean scaleToZeroEnabled) {
        this.scaleToZeroEnabled = scaleToZeroEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasScaleToZeroEnabled() {
        return true;
    }

    @Override
    @Deprecated
    public AutoScaling getRevisionAutoScaling() {
        return this.revisionAutoScaling != null ? this.revisionAutoScaling.build() : null;
    }

    @Override
    public AutoScaling buildRevisionAutoScaling() {
        return this.revisionAutoScaling != null ? this.revisionAutoScaling.build() : null;
    }

    @Override
    public A withRevisionAutoScaling(AutoScaling revisionAutoScaling) {
        this._visitables.get((Object)"revisionAutoScaling").remove(this.revisionAutoScaling);
        if (revisionAutoScaling != null) {
            this.revisionAutoScaling = new AutoScalingBuilder(revisionAutoScaling);
            this._visitables.get((Object)"revisionAutoScaling").add(this.revisionAutoScaling);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRevisionAutoScaling() {
        return this.revisionAutoScaling != null;
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScaling() {
        return new RevisionAutoScalingNestedImpl();
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScalingLike(AutoScaling item) {
        return new RevisionAutoScalingNestedImpl(item);
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editRevisionAutoScaling() {
        return this.withNewRevisionAutoScalingLike(this.getRevisionAutoScaling());
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScaling() {
        return this.withNewRevisionAutoScalingLike(this.getRevisionAutoScaling() != null ? this.getRevisionAutoScaling() : new AutoScalingBuilder().build());
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScalingLike(AutoScaling item) {
        return this.withNewRevisionAutoScalingLike(this.getRevisionAutoScaling() != null ? this.getRevisionAutoScaling() : item);
    }

    @Override
    @Deprecated
    public GlobalAutoScaling getGlobalAutoScaling() {
        return this.globalAutoScaling != null ? this.globalAutoScaling.build() : null;
    }

    @Override
    public GlobalAutoScaling buildGlobalAutoScaling() {
        return this.globalAutoScaling != null ? this.globalAutoScaling.build() : null;
    }

    @Override
    public A withGlobalAutoScaling(GlobalAutoScaling globalAutoScaling) {
        this._visitables.get((Object)"globalAutoScaling").remove(this.globalAutoScaling);
        if (globalAutoScaling != null) {
            this.globalAutoScaling = new GlobalAutoScalingBuilder(globalAutoScaling);
            this._visitables.get((Object)"globalAutoScaling").add(this.globalAutoScaling);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGlobalAutoScaling() {
        return this.globalAutoScaling != null;
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScaling() {
        return new GlobalAutoScalingNestedImpl();
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScalingLike(GlobalAutoScaling item) {
        return new GlobalAutoScalingNestedImpl(item);
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editGlobalAutoScaling() {
        return this.withNewGlobalAutoScalingLike(this.getGlobalAutoScaling());
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScaling() {
        return this.withNewGlobalAutoScalingLike(this.getGlobalAutoScaling() != null ? this.getGlobalAutoScaling() : new GlobalAutoScalingBuilder().build());
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScalingLike(GlobalAutoScaling item) {
        return this.withNewGlobalAutoScalingLike(this.getGlobalAutoScaling() != null ? this.getGlobalAutoScaling() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnativeConfigFluentImpl that = (KnativeConfigFluentImpl)o;
        if (this.httpTransportVersion != null ? !this.httpTransportVersion.equals((Object)that.httpTransportVersion) : that.httpTransportVersion != null) {
            return false;
        }
        if (this.minScale != that.minScale) {
            return false;
        }
        if (this.maxScale != that.maxScale) {
            return false;
        }
        if (this.scaleToZeroEnabled != that.scaleToZeroEnabled) {
            return false;
        }
        if (this.revisionAutoScaling != null ? !this.revisionAutoScaling.equals(that.revisionAutoScaling) : that.revisionAutoScaling != null) {
            return false;
        }
        return !(this.globalAutoScaling != null ? !this.globalAutoScaling.equals(that.globalAutoScaling) : that.globalAutoScaling != null);
    }

    public class GlobalAutoScalingNestedImpl<N>
    extends GlobalAutoScalingFluentImpl<KnativeConfigFluent.GlobalAutoScalingNested<N>>
    implements KnativeConfigFluent.GlobalAutoScalingNested<N>,
    Nested<N> {
        private final GlobalAutoScalingBuilder builder;

        GlobalAutoScalingNestedImpl(GlobalAutoScaling item) {
            this.builder = new GlobalAutoScalingBuilder(this, item);
        }

        GlobalAutoScalingNestedImpl() {
            this.builder = new GlobalAutoScalingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KnativeConfigFluentImpl.this.withGlobalAutoScaling(this.builder.build());
        }

        @Override
        public N endGlobalAutoScaling() {
            return this.and();
        }
    }

    public class RevisionAutoScalingNestedImpl<N>
    extends AutoScalingFluentImpl<KnativeConfigFluent.RevisionAutoScalingNested<N>>
    implements KnativeConfigFluent.RevisionAutoScalingNested<N>,
    Nested<N> {
        private final AutoScalingBuilder builder;

        RevisionAutoScalingNestedImpl(AutoScaling item) {
            this.builder = new AutoScalingBuilder(this, item);
        }

        RevisionAutoScalingNestedImpl() {
            this.builder = new AutoScalingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KnativeConfigFluentImpl.this.withRevisionAutoScaling(this.builder.build());
        }

        @Override
        public N endRevisionAutoScaling() {
            return this.and();
        }
    }
}

