/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.knative.config.AutoScalerClass;
import io.dekorate.knative.config.AutoScaling;
import io.dekorate.knative.config.AutoScalingFluent;
import io.dekorate.knative.config.AutoscalingMetric;
import java.util.Objects;

public class AutoScalingFluentImpl<A extends AutoScalingFluent<A>>
extends BaseFluent<A>
implements AutoScalingFluent<A> {
    private AutoScalerClass autoScalerClass = AutoScalerClass.kpa;
    private AutoscalingMetric metric = AutoscalingMetric.concurrency;
    private int target = 0;
    private int containerConcurrency = 0;
    private int targetUtilizationPercentage = 70;

    public AutoScalingFluentImpl() {
    }

    public AutoScalingFluentImpl(AutoScaling instance) {
        this.withAutoScalerClass(instance.getAutoScalerClass());
        this.withMetric(instance.getMetric());
        this.withTarget(instance.getTarget());
        this.withContainerConcurrency(instance.getContainerConcurrency());
        this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage());
    }

    @Override
    public AutoScalerClass getAutoScalerClass() {
        return this.autoScalerClass;
    }

    @Override
    public A withAutoScalerClass(AutoScalerClass autoScalerClass) {
        this.autoScalerClass = autoScalerClass;
        return (A)this;
    }

    @Override
    public Boolean hasAutoScalerClass() {
        return this.autoScalerClass != null;
    }

    @Override
    public AutoscalingMetric getMetric() {
        return this.metric;
    }

    @Override
    public A withMetric(AutoscalingMetric metric) {
        this.metric = metric;
        return (A)this;
    }

    @Override
    public Boolean hasMetric() {
        return this.metric != null;
    }

    @Override
    public int getTarget() {
        return this.target;
    }

    @Override
    public A withTarget(int target) {
        this.target = target;
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return true;
    }

    @Override
    public int getContainerConcurrency() {
        return this.containerConcurrency;
    }

    @Override
    public A withContainerConcurrency(int containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
        return (A)this;
    }

    @Override
    public Boolean hasContainerConcurrency() {
        return true;
    }

    @Override
    public int getTargetUtilizationPercentage() {
        return this.targetUtilizationPercentage;
    }

    @Override
    public A withTargetUtilizationPercentage(int targetUtilizationPercentage) {
        this.targetUtilizationPercentage = targetUtilizationPercentage;
        return (A)this;
    }

    @Override
    public Boolean hasTargetUtilizationPercentage() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoScalingFluentImpl that = (AutoScalingFluentImpl)o;
        if (this.autoScalerClass != null ? !this.autoScalerClass.equals((Object)that.autoScalerClass) : that.autoScalerClass != null) {
            return false;
        }
        if (this.metric != null ? !this.metric.equals((Object)that.metric) : that.metric != null) {
            return false;
        }
        if (this.target != that.target) {
            return false;
        }
        if (this.containerConcurrency != that.containerConcurrency) {
            return false;
        }
        return this.targetUtilizationPercentage == that.targetUtilizationPercentage;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoScalerClass, this.metric, this.target, this.containerConcurrency, this.targetUtilizationPercentage, super.hashCode()});
    }
}

