package io.dekorate.knative.config;

import java.lang.Object;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class AutoScaling {

    private AutoScalerClass autoScalerClass = io.dekorate.knative.config.AutoScalerClass.kpa;
    private AutoscalingMetric metric = io.dekorate.knative.config.AutoscalingMetric.concurrency;
    private int target = 0;
    private int containerConcurrency = 0;
    private int targetUtilizationPercentage = 70;

    public AutoScaling() { 
    }


    public AutoScaling(AutoScalerClass autoScalerClass,AutoscalingMetric metric,int target,int containerConcurrency,int targetUtilizationPercentage) { 
        this.autoScalerClass = autoScalerClass != null ? autoScalerClass : io.dekorate.knative.config.AutoScalerClass.kpa;
        this.metric = metric != null ? metric : io.dekorate.knative.config.AutoscalingMetric.concurrency;
        this.target = target;
        this.containerConcurrency = containerConcurrency;
        this.targetUtilizationPercentage = targetUtilizationPercentage;
    }


    public AutoScalerClass getAutoScalerClass() {
        return this.autoScalerClass;
    }

    public AutoscalingMetric getMetric() {
        return this.metric;
    }

    public int getTarget() {
        return this.target;
    }

    public int getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public int getTargetUtilizationPercentage() {
        return this.targetUtilizationPercentage;
    }

    public static AutoScalingBuilder newBuilder() {
        return new io.dekorate.knative.config.AutoScalingBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AutoScaling that = (AutoScaling) o;
        if (autoScalerClass != null ? !autoScalerClass.equals(that.autoScalerClass) :that.autoScalerClass != null) return false;
        if (metric != null ? !metric.equals(that.metric) :that.metric != null) return false;
        if (target != that.target) return false;
        if (containerConcurrency != that.containerConcurrency) return false;
        if (targetUtilizationPercentage != that.targetUtilizationPercentage) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(autoScalerClass,  metric,  target,  containerConcurrency,  targetUtilizationPercentage,  super.hashCode());
    }

}
