package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AutoScalingBuilder extends AutoScalingFluentImpl<AutoScalingBuilder> implements VisitableBuilder<io.dekorate.knative.config.AutoScaling,AutoScalingBuilder> {

    AutoScalingFluent<?> fluent;
    Boolean validationEnabled;

    public AutoScalingBuilder() { 
        this(true);
    }


    public AutoScalingBuilder(Boolean validationEnabled) { 
        this(new AutoScaling(), validationEnabled);
    }


    public AutoScalingBuilder(AutoScalingFluent<?> fluent) { 
        this(fluent, true);
    }


    public AutoScalingBuilder(AutoScalingFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AutoScaling(), validationEnabled);
    }


    public AutoScalingBuilder(AutoScalingFluent<?> fluent,io.dekorate.knative.config.AutoScaling instance) { 
        this(fluent, instance, true);
    }


    public AutoScalingBuilder(AutoScalingFluent<?> fluent,io.dekorate.knative.config.AutoScaling instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAutoScalerClass(instance.getAutoScalerClass()); 
        fluent.withMetric(instance.getMetric()); 
        fluent.withTarget(instance.getTarget()); 
        fluent.withContainerConcurrency(instance.getContainerConcurrency()); 
        fluent.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage()); 
        this.validationEnabled = validationEnabled; 
    }


    public AutoScalingBuilder(io.dekorate.knative.config.AutoScaling instance) { 
        this(instance,true);
    }


    public AutoScalingBuilder(io.dekorate.knative.config.AutoScaling instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAutoScalerClass(instance.getAutoScalerClass()); 
        this.withMetric(instance.getMetric()); 
        this.withTarget(instance.getTarget()); 
        this.withContainerConcurrency(instance.getContainerConcurrency()); 
        this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage()); 
        this.validationEnabled = validationEnabled; 
    }


    public EditableAutoScaling build() {
        EditableAutoScaling buildable = new EditableAutoScaling(fluent.getAutoScalerClass(),fluent.getMetric(),fluent.getTarget(),fluent.getContainerConcurrency(),fluent.getTargetUtilizationPercentage());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AutoScalingBuilder that = (AutoScalingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
