package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.Fluent;
import java.lang.Boolean;

public interface AutoScalingFluent<A extends AutoScalingFluent<A>> extends Fluent<A> {


    public AutoScalerClass getAutoScalerClass();
    public A withAutoScalerClass(AutoScalerClass autoScalerClass);
    public Boolean hasAutoScalerClass();
    public AutoscalingMetric getMetric();
    public A withMetric(AutoscalingMetric metric);
    public Boolean hasMetric();
    public int getTarget();
    public A withTarget(int target);
    public Boolean hasTarget();
    public int getContainerConcurrency();
    public A withContainerConcurrency(int containerConcurrency);
    public Boolean hasContainerConcurrency();
    public int getTargetUtilizationPercentage();
    public A withTargetUtilizationPercentage(int targetUtilizationPercentage);
    public Boolean hasTargetUtilizationPercentage();
}
