package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class AutoScalingFluentImpl<A extends AutoScalingFluent<A>> extends BaseFluent<A> implements AutoScalingFluent<A> {

    private AutoScalerClass autoScalerClass = io.dekorate.knative.config.AutoScalerClass.kpa;
    private AutoscalingMetric metric = io.dekorate.knative.config.AutoscalingMetric.concurrency;
    private int target = 0;
    private int containerConcurrency = 0;
    private int targetUtilizationPercentage = 70;

    public AutoScalingFluentImpl() { 
    }


    public AutoScalingFluentImpl(io.dekorate.knative.config.AutoScaling instance) { 
        this.withAutoScalerClass(instance.getAutoScalerClass()); 
        this.withMetric(instance.getMetric()); 
        this.withTarget(instance.getTarget()); 
        this.withContainerConcurrency(instance.getContainerConcurrency()); 
        this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage()); 
    }


    public AutoScalerClass getAutoScalerClass() {
        return this.autoScalerClass;
    }

    public A withAutoScalerClass(AutoScalerClass autoScalerClass) {
        this.autoScalerClass=autoScalerClass; return (A) this;
    }

    public Boolean hasAutoScalerClass() {
        return this.autoScalerClass != null;
    }

    public AutoscalingMetric getMetric() {
        return this.metric;
    }

    public A withMetric(AutoscalingMetric metric) {
        this.metric=metric; return (A) this;
    }

    public Boolean hasMetric() {
        return this.metric != null;
    }

    public int getTarget() {
        return this.target;
    }

    public A withTarget(int target) {
        this.target=target; return (A) this;
    }

    public Boolean hasTarget() {
        return true;
    }

    public int getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public A withContainerConcurrency(int containerConcurrency) {
        this.containerConcurrency=containerConcurrency; return (A) this;
    }

    public Boolean hasContainerConcurrency() {
        return true;
    }

    public int getTargetUtilizationPercentage() {
        return this.targetUtilizationPercentage;
    }

    public A withTargetUtilizationPercentage(int targetUtilizationPercentage) {
        this.targetUtilizationPercentage=targetUtilizationPercentage; return (A) this;
    }

    public Boolean hasTargetUtilizationPercentage() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AutoScalingFluentImpl that = (AutoScalingFluentImpl) o;
        if (autoScalerClass != null ? !autoScalerClass.equals(that.autoScalerClass) :that.autoScalerClass != null) return false;
        if (metric != null ? !metric.equals(that.metric) :that.metric != null) return false;
        if (target != that.target) return false;
        if (containerConcurrency != that.containerConcurrency) return false;
        if (targetUtilizationPercentage != that.targetUtilizationPercentage) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(autoScalerClass,  metric,  target,  containerConcurrency,  targetUtilizationPercentage,  super.hashCode());
    }

}
