package io.dekorate.knative.config;

import java.lang.Object;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class GlobalAutoScaling {

    private AutoScalerClass autoScalerClass = io.dekorate.knative.config.AutoScalerClass.kpa;
    private int containerConcurrency = 0;
    private int targetUtilizationPercentage = 70;
    private int requestsPerSecond = 200;

    public GlobalAutoScaling() { 
    }


    public GlobalAutoScaling(AutoScalerClass autoScalerClass,int containerConcurrency,int targetUtilizationPercentage,int requestsPerSecond) { 
        this.autoScalerClass = autoScalerClass != null ? autoScalerClass : io.dekorate.knative.config.AutoScalerClass.kpa;
        this.containerConcurrency = containerConcurrency;
        this.targetUtilizationPercentage = targetUtilizationPercentage;
        this.requestsPerSecond = requestsPerSecond;
    }


    public AutoScalerClass getAutoScalerClass() {
        return this.autoScalerClass;
    }

    public int getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public int getTargetUtilizationPercentage() {
        return this.targetUtilizationPercentage;
    }

    public int getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public static GlobalAutoScalingBuilder newBuilder() {
        return new io.dekorate.knative.config.GlobalAutoScalingBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GlobalAutoScaling that = (GlobalAutoScaling) o;
        if (autoScalerClass != null ? !autoScalerClass.equals(that.autoScalerClass) :that.autoScalerClass != null) return false;
        if (containerConcurrency != that.containerConcurrency) return false;
        if (targetUtilizationPercentage != that.targetUtilizationPercentage) return false;
        if (requestsPerSecond != that.requestsPerSecond) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(autoScalerClass,  containerConcurrency,  targetUtilizationPercentage,  requestsPerSecond,  super.hashCode());
    }

}
