package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GlobalAutoScalingBuilder extends GlobalAutoScalingFluentImpl<GlobalAutoScalingBuilder> implements VisitableBuilder<io.dekorate.knative.config.GlobalAutoScaling,GlobalAutoScalingBuilder> {

    GlobalAutoScalingFluent<?> fluent;
    Boolean validationEnabled;

    public GlobalAutoScalingBuilder() { 
        this(true);
    }


    public GlobalAutoScalingBuilder(Boolean validationEnabled) { 
        this(new GlobalAutoScaling(), validationEnabled);
    }


    public GlobalAutoScalingBuilder(GlobalAutoScalingFluent<?> fluent) { 
        this(fluent, true);
    }


    public GlobalAutoScalingBuilder(GlobalAutoScalingFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GlobalAutoScaling(), validationEnabled);
    }


    public GlobalAutoScalingBuilder(GlobalAutoScalingFluent<?> fluent,io.dekorate.knative.config.GlobalAutoScaling instance) { 
        this(fluent, instance, true);
    }


    public GlobalAutoScalingBuilder(GlobalAutoScalingFluent<?> fluent,io.dekorate.knative.config.GlobalAutoScaling instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAutoScalerClass(instance.getAutoScalerClass()); 
        fluent.withContainerConcurrency(instance.getContainerConcurrency()); 
        fluent.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage()); 
        fluent.withRequestsPerSecond(instance.getRequestsPerSecond()); 
        this.validationEnabled = validationEnabled; 
    }


    public GlobalAutoScalingBuilder(io.dekorate.knative.config.GlobalAutoScaling instance) { 
        this(instance,true);
    }


    public GlobalAutoScalingBuilder(io.dekorate.knative.config.GlobalAutoScaling instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAutoScalerClass(instance.getAutoScalerClass()); 
        this.withContainerConcurrency(instance.getContainerConcurrency()); 
        this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage()); 
        this.withRequestsPerSecond(instance.getRequestsPerSecond()); 
        this.validationEnabled = validationEnabled; 
    }


    public EditableGlobalAutoScaling build() {
        EditableGlobalAutoScaling buildable = new EditableGlobalAutoScaling(fluent.getAutoScalerClass(),fluent.getContainerConcurrency(),fluent.getTargetUtilizationPercentage(),fluent.getRequestsPerSecond());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GlobalAutoScalingBuilder that = (GlobalAutoScalingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
