package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.Fluent;
import java.lang.Boolean;

public interface GlobalAutoScalingFluent<A extends GlobalAutoScalingFluent<A>> extends Fluent<A> {


    public AutoScalerClass getAutoScalerClass();
    public A withAutoScalerClass(AutoScalerClass autoScalerClass);
    public Boolean hasAutoScalerClass();
    public int getContainerConcurrency();
    public A withContainerConcurrency(int containerConcurrency);
    public Boolean hasContainerConcurrency();
    public int getTargetUtilizationPercentage();
    public A withTargetUtilizationPercentage(int targetUtilizationPercentage);
    public Boolean hasTargetUtilizationPercentage();
    public int getRequestsPerSecond();
    public A withRequestsPerSecond(int requestsPerSecond);
    public Boolean hasRequestsPerSecond();
}
