package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class GlobalAutoScalingFluentImpl<A extends GlobalAutoScalingFluent<A>> extends BaseFluent<A> implements GlobalAutoScalingFluent<A> {

    private AutoScalerClass autoScalerClass = io.dekorate.knative.config.AutoScalerClass.kpa;
    private int containerConcurrency = 0;
    private int targetUtilizationPercentage = 70;
    private int requestsPerSecond = 200;

    public GlobalAutoScalingFluentImpl() { 
    }


    public GlobalAutoScalingFluentImpl(io.dekorate.knative.config.GlobalAutoScaling instance) { 
        this.withAutoScalerClass(instance.getAutoScalerClass()); 
        this.withContainerConcurrency(instance.getContainerConcurrency()); 
        this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage()); 
        this.withRequestsPerSecond(instance.getRequestsPerSecond()); 
    }


    public AutoScalerClass getAutoScalerClass() {
        return this.autoScalerClass;
    }

    public A withAutoScalerClass(AutoScalerClass autoScalerClass) {
        this.autoScalerClass=autoScalerClass; return (A) this;
    }

    public Boolean hasAutoScalerClass() {
        return this.autoScalerClass != null;
    }

    public int getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public A withContainerConcurrency(int containerConcurrency) {
        this.containerConcurrency=containerConcurrency; return (A) this;
    }

    public Boolean hasContainerConcurrency() {
        return true;
    }

    public int getTargetUtilizationPercentage() {
        return this.targetUtilizationPercentage;
    }

    public A withTargetUtilizationPercentage(int targetUtilizationPercentage) {
        this.targetUtilizationPercentage=targetUtilizationPercentage; return (A) this;
    }

    public Boolean hasTargetUtilizationPercentage() {
        return true;
    }

    public int getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public A withRequestsPerSecond(int requestsPerSecond) {
        this.requestsPerSecond=requestsPerSecond; return (A) this;
    }

    public Boolean hasRequestsPerSecond() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GlobalAutoScalingFluentImpl that = (GlobalAutoScalingFluentImpl) o;
        if (autoScalerClass != null ? !autoScalerClass.equals(that.autoScalerClass) :that.autoScalerClass != null) return false;
        if (containerConcurrency != that.containerConcurrency) return false;
        if (targetUtilizationPercentage != that.targetUtilizationPercentage) return false;
        if (requestsPerSecond != that.requestsPerSecond) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(autoScalerClass,  containerConcurrency,  targetUtilizationPercentage,  requestsPerSecond,  super.hashCode());
    }

}
