package io.dekorate.knative.config;

import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.lang.Object;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class KnativeConfig extends BaseConfig {

    private String revisionName = "";
    private HttpTransportVersion httpTransportVersion = io.dekorate.knative.config.HttpTransportVersion.HTTP1;
    private int minScale = 0;
    private int maxScale = 0;
    private boolean scaleToZeroEnabled = true;
    private io.dekorate.knative.config.AutoScaling revisionAutoScaling = null;
    private io.dekorate.knative.config.GlobalAutoScaling globalAutoScaling = null;
    private String templateName = "";
    private io.dekorate.knative.config.Traffic[] traffic = new io.dekorate.knative.config.Traffic[0];

    public KnativeConfig() { 
    }


    public KnativeConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,String name,String version,io.dekorate.kubernetes.config.Label[] labels,io.dekorate.kubernetes.config.Annotation[] annotations,io.dekorate.kubernetes.config.Env[] envVars,String workingDir,String[] command,String[] arguments,String serviceAccount,String host,io.dekorate.kubernetes.config.Port[] ports,ServiceType serviceType,io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[] pvcVolumes,io.dekorate.kubernetes.config.SecretVolume[] secretVolumes,io.dekorate.kubernetes.config.ConfigMapVolume[] configMapVolumes,io.dekorate.kubernetes.config.GitRepoVolume[] gitRepoVolumes,io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,io.dekorate.kubernetes.config.AzureDiskVolume[] azureDiskVolumes,io.dekorate.kubernetes.config.AzureFileVolume[] azureFileVolumes,io.dekorate.kubernetes.config.Mount[] mounts,ImagePullPolicy imagePullPolicy,String[] imagePullSecrets,HostAlias[] hostAliases,io.dekorate.kubernetes.config.Probe livenessProbe,io.dekorate.kubernetes.config.Probe readinessProbe,io.dekorate.kubernetes.config.ResourceRequirements requestResources,io.dekorate.kubernetes.config.ResourceRequirements limitResources,io.dekorate.kubernetes.config.Container[] sidecars,boolean expose,boolean autoDeployEnabled,String revisionName,HttpTransportVersion httpTransportVersion,int minScale,int maxScale,boolean scaleToZeroEnabled,io.dekorate.knative.config.AutoScaling revisionAutoScaling,io.dekorate.knative.config.GlobalAutoScaling globalAutoScaling,String templateName,io.dekorate.knative.config.Traffic[] traffic) { 
        super(project, attributes, partOf, name, version, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, host, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, hostAliases, livenessProbe, readinessProbe, requestResources, limitResources, sidecars, expose, autoDeployEnabled);
        this.revisionName = revisionName != null ? revisionName : "";
        this.httpTransportVersion = httpTransportVersion != null ? httpTransportVersion : io.dekorate.knative.config.HttpTransportVersion.HTTP1;
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.scaleToZeroEnabled = scaleToZeroEnabled;
        this.revisionAutoScaling = revisionAutoScaling != null ? revisionAutoScaling : null;
        this.globalAutoScaling = globalAutoScaling != null ? globalAutoScaling : null;
        this.templateName = templateName != null ? templateName : "";
        this.traffic = traffic != null ? traffic : new io.dekorate.knative.config.Traffic[0];
    }


    public String getRevisionName() {
        return this.revisionName;
    }

    public HttpTransportVersion getHttpTransportVersion() {
        return this.httpTransportVersion;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public boolean isScaleToZeroEnabled() {
        return this.scaleToZeroEnabled;
    }

    public io.dekorate.knative.config.AutoScaling getRevisionAutoScaling() {
        return this.revisionAutoScaling;
    }

    public io.dekorate.knative.config.GlobalAutoScaling getGlobalAutoScaling() {
        return this.globalAutoScaling;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public io.dekorate.knative.config.Traffic[] getTraffic() {
        return this.traffic;
    }

    public static KnativeConfigBuilder newKnativeConfigBuilder() {
        return new io.dekorate.knative.config.KnativeConfigBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KnativeConfig that = (KnativeConfig) o;
        if (revisionName != null ? !revisionName.equals(that.revisionName) :that.revisionName != null) return false;
        if (httpTransportVersion != null ? !httpTransportVersion.equals(that.httpTransportVersion) :that.httpTransportVersion != null) return false;
        if (minScale != that.minScale) return false;
        if (maxScale != that.maxScale) return false;
        if (scaleToZeroEnabled != that.scaleToZeroEnabled) return false;
        if (revisionAutoScaling != null ? !revisionAutoScaling.equals(that.revisionAutoScaling) :that.revisionAutoScaling != null) return false;
        if (globalAutoScaling != null ? !globalAutoScaling.equals(that.globalAutoScaling) :that.globalAutoScaling != null) return false;
        if (templateName != null ? !templateName.equals(that.templateName) :that.templateName != null) return false;
        if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(revisionName,  httpTransportVersion,  minScale,  maxScale,  scaleToZeroEnabled,  revisionAutoScaling,  globalAutoScaling,  templateName,  traffic,  super.hashCode());
    }

}
