package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KnativeConfigBuilder extends KnativeConfigFluentImpl<KnativeConfigBuilder> implements VisitableBuilder<KnativeConfig,KnativeConfigBuilder> {

    KnativeConfigFluent<?> fluent;
    Boolean validationEnabled;

    public KnativeConfigBuilder() { 
        this(true);
    }


    public KnativeConfigBuilder(Boolean validationEnabled) { 
        this(new KnativeConfig(), validationEnabled);
    }


    public KnativeConfigBuilder(KnativeConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public KnativeConfigBuilder(KnativeConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KnativeConfig(), validationEnabled);
    }


    public KnativeConfigBuilder(KnativeConfigFluent<?> fluent,KnativeConfig instance) { 
        this(fluent, instance, true);
    }


    public KnativeConfigBuilder(KnativeConfigFluent<?> fluent,KnativeConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withProject(instance.getProject()); 
        fluent.withAttributes(instance.getAttributes()); 
        fluent.withPartOf(instance.getPartOf()); 
        fluent.withName(instance.getName()); 
        fluent.withVersion(instance.getVersion()); 
        fluent.withLabels(instance.getLabels()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withEnvVars(instance.getEnvVars()); 
        fluent.withWorkingDir(instance.getWorkingDir()); 
        fluent.withCommand(instance.getCommand()); 
        fluent.withArguments(instance.getArguments()); 
        fluent.withServiceAccount(instance.getServiceAccount()); 
        fluent.withHost(instance.getHost()); 
        fluent.withPorts(instance.getPorts()); 
        fluent.withServiceType(instance.getServiceType()); 
        fluent.withPvcVolumes(instance.getPvcVolumes()); 
        fluent.withSecretVolumes(instance.getSecretVolumes()); 
        fluent.withConfigMapVolumes(instance.getConfigMapVolumes()); 
        fluent.withGitRepoVolumes(instance.getGitRepoVolumes()); 
        fluent.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
        fluent.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
        fluent.withAzureFileVolumes(instance.getAzureFileVolumes()); 
        fluent.withMounts(instance.getMounts()); 
        fluent.withImagePullPolicy(instance.getImagePullPolicy()); 
        fluent.withImagePullSecrets(instance.getImagePullSecrets()); 
        fluent.withHostAliases(instance.getHostAliases()); 
        fluent.withLivenessProbe(instance.getLivenessProbe()); 
        fluent.withReadinessProbe(instance.getReadinessProbe()); 
        fluent.withRequestResources(instance.getRequestResources()); 
        fluent.withLimitResources(instance.getLimitResources()); 
        fluent.withSidecars(instance.getSidecars()); 
        fluent.withExpose(instance.isExpose()); 
        fluent.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
        fluent.withRevisionName(instance.getRevisionName()); 
        fluent.withHttpTransportVersion(instance.getHttpTransportVersion()); 
        fluent.withMinScale(instance.getMinScale()); 
        fluent.withMaxScale(instance.getMaxScale()); 
        fluent.withScaleToZeroEnabled(instance.isScaleToZeroEnabled()); 
        fluent.withRevisionAutoScaling(instance.getRevisionAutoScaling()); 
        fluent.withGlobalAutoScaling(instance.getGlobalAutoScaling()); 
        fluent.withTemplateName(instance.getTemplateName()); 
        fluent.withTraffic(instance.getTraffic()); 
        this.validationEnabled = validationEnabled; 
    }


    public KnativeConfigBuilder(KnativeConfig instance) { 
        this(instance,true);
    }


    public KnativeConfigBuilder(KnativeConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withPartOf(instance.getPartOf()); 
        this.withName(instance.getName()); 
        this.withVersion(instance.getVersion()); 
        this.withLabels(instance.getLabels()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withEnvVars(instance.getEnvVars()); 
        this.withWorkingDir(instance.getWorkingDir()); 
        this.withCommand(instance.getCommand()); 
        this.withArguments(instance.getArguments()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withHost(instance.getHost()); 
        this.withPorts(instance.getPorts()); 
        this.withServiceType(instance.getServiceType()); 
        this.withPvcVolumes(instance.getPvcVolumes()); 
        this.withSecretVolumes(instance.getSecretVolumes()); 
        this.withConfigMapVolumes(instance.getConfigMapVolumes()); 
        this.withGitRepoVolumes(instance.getGitRepoVolumes()); 
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
        this.withAzureFileVolumes(instance.getAzureFileVolumes()); 
        this.withMounts(instance.getMounts()); 
        this.withImagePullPolicy(instance.getImagePullPolicy()); 
        this.withImagePullSecrets(instance.getImagePullSecrets()); 
        this.withHostAliases(instance.getHostAliases()); 
        this.withLivenessProbe(instance.getLivenessProbe()); 
        this.withReadinessProbe(instance.getReadinessProbe()); 
        this.withRequestResources(instance.getRequestResources()); 
        this.withLimitResources(instance.getLimitResources()); 
        this.withSidecars(instance.getSidecars()); 
        this.withExpose(instance.isExpose()); 
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
        this.withRevisionName(instance.getRevisionName()); 
        this.withHttpTransportVersion(instance.getHttpTransportVersion()); 
        this.withMinScale(instance.getMinScale()); 
        this.withMaxScale(instance.getMaxScale()); 
        this.withScaleToZeroEnabled(instance.isScaleToZeroEnabled()); 
        this.withRevisionAutoScaling(instance.getRevisionAutoScaling()); 
        this.withGlobalAutoScaling(instance.getGlobalAutoScaling()); 
        this.withTemplateName(instance.getTemplateName()); 
        this.withTraffic(instance.getTraffic()); 
        this.validationEnabled = validationEnabled; 
    }


    public EditableKnativeConfig build() {
        EditableKnativeConfig buildable = new EditableKnativeConfig(fluent.getProject(),fluent.getAttributes(),fluent.getPartOf(),fluent.getName(),fluent.getVersion(),fluent.getLabels(),fluent.getAnnotations(),fluent.getEnvVars(),fluent.getWorkingDir(),fluent.getCommand(),fluent.getArguments(),fluent.getServiceAccount(),fluent.getHost(),fluent.getPorts(),fluent.getServiceType(),fluent.getPvcVolumes(),fluent.getSecretVolumes(),fluent.getConfigMapVolumes(),fluent.getGitRepoVolumes(),fluent.getAwsElasticBlockStoreVolumes(),fluent.getAzureDiskVolumes(),fluent.getAzureFileVolumes(),fluent.getMounts(),fluent.getImagePullPolicy(),fluent.getImagePullSecrets(),fluent.getHostAliases(),fluent.getLivenessProbe(),fluent.getReadinessProbe(),fluent.getRequestResources(),fluent.getLimitResources(),fluent.getSidecars(),fluent.isExpose(),fluent.isAutoDeployEnabled(),fluent.getRevisionName(),fluent.getHttpTransportVersion(),fluent.getMinScale(),fluent.getMaxScale(),fluent.isScaleToZeroEnabled(),fluent.getRevisionAutoScaling(),fluent.getGlobalAutoScaling(),fluent.getTemplateName(),fluent.getTraffic());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KnativeConfigBuilder that = (KnativeConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
