package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import java.lang.StringBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.util.ArrayList;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.kubernetes.config.Container;
import java.lang.Deprecated;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.util.Iterator;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.project.Project;
import java.lang.StringBuffer;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

public interface KnativeConfigFluent<A extends KnativeConfigFluent<A>> extends BaseConfigFluent<A> {


    public String getRevisionName();
    public A withRevisionName(String revisionName);
    public Boolean hasRevisionName();
    public A withNewRevisionName(String arg1);
    public A withNewRevisionName(StringBuilder arg1);
    public A withNewRevisionName(StringBuffer arg1);
    public HttpTransportVersion getHttpTransportVersion();
    public A withHttpTransportVersion(HttpTransportVersion httpTransportVersion);
    public Boolean hasHttpTransportVersion();
    public int getMinScale();
    public A withMinScale(int minScale);
    public Boolean hasMinScale();
    public int getMaxScale();
    public A withMaxScale(int maxScale);
    public Boolean hasMaxScale();
    public boolean isScaleToZeroEnabled();
    public A withScaleToZeroEnabled(boolean scaleToZeroEnabled);
    public Boolean hasScaleToZeroEnabled();
    
/**
 * This method has been deprecated, please use method buildRevisionAutoScaling instead.
 * @return The buildable object.
 */
@Deprecated public io.dekorate.knative.config.AutoScaling getRevisionAutoScaling();
    public io.dekorate.knative.config.AutoScaling buildRevisionAutoScaling();
    public A withRevisionAutoScaling(io.dekorate.knative.config.AutoScaling revisionAutoScaling);
    public Boolean hasRevisionAutoScaling();
    public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScaling();
    public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScalingLike(io.dekorate.knative.config.AutoScaling item);
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editRevisionAutoScaling();
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScaling();
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScalingLike(io.dekorate.knative.config.AutoScaling item);
    
/**
 * This method has been deprecated, please use method buildGlobalAutoScaling instead.
 * @return The buildable object.
 */
@Deprecated public io.dekorate.knative.config.GlobalAutoScaling getGlobalAutoScaling();
    public io.dekorate.knative.config.GlobalAutoScaling buildGlobalAutoScaling();
    public A withGlobalAutoScaling(io.dekorate.knative.config.GlobalAutoScaling globalAutoScaling);
    public Boolean hasGlobalAutoScaling();
    public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScaling();
    public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScalingLike(io.dekorate.knative.config.GlobalAutoScaling item);
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editGlobalAutoScaling();
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScaling();
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScalingLike(io.dekorate.knative.config.GlobalAutoScaling item);
    public String getTemplateName();
    public A withTemplateName(String templateName);
    public Boolean hasTemplateName();
    public A withNewTemplateName(String arg1);
    public A withNewTemplateName(StringBuilder arg1);
    public A withNewTemplateName(StringBuffer arg1);
    public A withTraffic(io.dekorate.knative.config.Traffic... traffic);
    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 */
@Deprecated public io.dekorate.knative.config.Traffic[] getTraffic();
    public io.dekorate.knative.config.Traffic[] buildTraffic();
    public io.dekorate.knative.config.Traffic buildTraffic(int index);
    public io.dekorate.knative.config.Traffic buildFirstTraffic();
    public io.dekorate.knative.config.Traffic buildLastTraffic();
    public io.dekorate.knative.config.Traffic buildMatchingTraffic(io.dekorate.deps.kubernetes.api.builder.Predicate<TrafficBuilder> predicate);
    public Boolean hasMatchingTraffic(io.dekorate.deps.kubernetes.api.builder.Predicate<TrafficBuilder> predicate);
    public A addToTraffic(int index,io.dekorate.knative.config.Traffic item);
    public A setToTraffic(int index,io.dekorate.knative.config.Traffic item);
    public A addToTraffic(io.dekorate.knative.config.Traffic... items);
    public A addAllToTraffic(Collection<io.dekorate.knative.config.Traffic> items);
    public A removeFromTraffic(io.dekorate.knative.config.Traffic... items);
    public A removeAllFromTraffic(Collection<io.dekorate.knative.config.Traffic> items);
    public A removeMatchingFromTraffic(io.dekorate.deps.kubernetes.api.builder.Predicate<TrafficBuilder> predicate);
    public Boolean hasTraffic();
    public A addNewTraffic(String tag,String revisionName,boolean latestRevision,int percentage);
    public KnativeConfigFluent.TrafficNested<A> addNewTraffic();
    public KnativeConfigFluent.TrafficNested<A> addNewTrafficLike(io.dekorate.knative.config.Traffic item);
    public KnativeConfigFluent.TrafficNested<A> setNewTrafficLike(int index,io.dekorate.knative.config.Traffic item);
    public KnativeConfigFluent.TrafficNested<A> editTraffic(int index);
    public KnativeConfigFluent.TrafficNested<A> editFirstTraffic();
    public KnativeConfigFluent.TrafficNested<A> editLastTraffic();
    public KnativeConfigFluent.TrafficNested<A> editMatchingTraffic(io.dekorate.deps.kubernetes.api.builder.Predicate<TrafficBuilder> predicate);
    public interface RevisionAutoScalingNested<N> extends io.dekorate.deps.kubernetes.api.builder.Nested<N>,AutoScalingFluent<KnativeConfigFluent.RevisionAutoScalingNested<N>> {

        public N and();
        public N endRevisionAutoScaling();    }


    public interface GlobalAutoScalingNested<N> extends io.dekorate.deps.kubernetes.api.builder.Nested<N>,GlobalAutoScalingFluent<KnativeConfigFluent.GlobalAutoScalingNested<N>> {

        public N and();
        public N endGlobalAutoScaling();    }


    public interface TrafficNested<N> extends io.dekorate.deps.kubernetes.api.builder.Nested<N>,TrafficFluent<KnativeConfigFluent.TrafficNested<N>> {

        public N and();
        public N endTraffic();    }


}
