package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import io.dekorate.kubernetes.config.BaseConfigFluentImpl;

public class KnativeConfigFluentImpl<A extends KnativeConfigFluent<A>> extends BaseConfigFluentImpl<A> implements KnativeConfigFluent<A> {

    private String revisionName = "";
    private HttpTransportVersion httpTransportVersion = io.dekorate.knative.config.HttpTransportVersion.HTTP1;
    private int minScale = 0;
    private int maxScale = 0;
    private boolean scaleToZeroEnabled = true;
    private AutoScalingBuilder revisionAutoScaling = new AutoScalingBuilder();
    private GlobalAutoScalingBuilder globalAutoScaling = new GlobalAutoScalingBuilder();
    private String templateName = "";
    private List<TrafficBuilder> traffic =  new ArrayList<TrafficBuilder>();

    public KnativeConfigFluentImpl() { 
    }


    public KnativeConfigFluentImpl(KnativeConfig instance) { 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withPartOf(instance.getPartOf()); 
        this.withName(instance.getName()); 
        this.withVersion(instance.getVersion()); 
        this.withLabels(instance.getLabels()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withEnvVars(instance.getEnvVars()); 
        this.withWorkingDir(instance.getWorkingDir()); 
        this.withCommand(instance.getCommand()); 
        this.withArguments(instance.getArguments()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withHost(instance.getHost()); 
        this.withPorts(instance.getPorts()); 
        this.withServiceType(instance.getServiceType()); 
        this.withPvcVolumes(instance.getPvcVolumes()); 
        this.withSecretVolumes(instance.getSecretVolumes()); 
        this.withConfigMapVolumes(instance.getConfigMapVolumes()); 
        this.withGitRepoVolumes(instance.getGitRepoVolumes()); 
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
        this.withAzureFileVolumes(instance.getAzureFileVolumes()); 
        this.withMounts(instance.getMounts()); 
        this.withImagePullPolicy(instance.getImagePullPolicy()); 
        this.withImagePullSecrets(instance.getImagePullSecrets()); 
        this.withHostAliases(instance.getHostAliases()); 
        this.withLivenessProbe(instance.getLivenessProbe()); 
        this.withReadinessProbe(instance.getReadinessProbe()); 
        this.withRequestResources(instance.getRequestResources()); 
        this.withLimitResources(instance.getLimitResources()); 
        this.withSidecars(instance.getSidecars()); 
        this.withExpose(instance.isExpose()); 
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
        this.withRevisionName(instance.getRevisionName()); 
        this.withHttpTransportVersion(instance.getHttpTransportVersion()); 
        this.withMinScale(instance.getMinScale()); 
        this.withMaxScale(instance.getMaxScale()); 
        this.withScaleToZeroEnabled(instance.isScaleToZeroEnabled()); 
        this.withRevisionAutoScaling(instance.getRevisionAutoScaling()); 
        this.withGlobalAutoScaling(instance.getGlobalAutoScaling()); 
        this.withTemplateName(instance.getTemplateName()); 
        this.withTraffic(instance.getTraffic()); 
    }


    public String getRevisionName() {
        return this.revisionName;
    }

    public A withRevisionName(String revisionName) {
        this.revisionName=revisionName; return (A) this;
    }

    public Boolean hasRevisionName() {
        return this.revisionName != null;
    }

    public A withNewRevisionName(String arg1) {
        return (A)withRevisionName(new String(arg1));
    }

    public A withNewRevisionName(StringBuilder arg1) {
        return (A)withRevisionName(new String(arg1));
    }

    public A withNewRevisionName(StringBuffer arg1) {
        return (A)withRevisionName(new String(arg1));
    }

    public HttpTransportVersion getHttpTransportVersion() {
        return this.httpTransportVersion;
    }

    public A withHttpTransportVersion(HttpTransportVersion httpTransportVersion) {
        this.httpTransportVersion=httpTransportVersion; return (A) this;
    }

    public Boolean hasHttpTransportVersion() {
        return this.httpTransportVersion != null;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public A withMinScale(int minScale) {
        this.minScale=minScale; return (A) this;
    }

    public Boolean hasMinScale() {
        return true;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public A withMaxScale(int maxScale) {
        this.maxScale=maxScale; return (A) this;
    }

    public Boolean hasMaxScale() {
        return true;
    }

    public boolean isScaleToZeroEnabled() {
        return this.scaleToZeroEnabled;
    }

    public A withScaleToZeroEnabled(boolean scaleToZeroEnabled) {
        this.scaleToZeroEnabled=scaleToZeroEnabled; return (A) this;
    }

    public Boolean hasScaleToZeroEnabled() {
        return true;
    }

    
/**
 * This method has been deprecated, please use method buildRevisionAutoScaling instead.
 * @return The buildable object.
 */
@Deprecated public io.dekorate.knative.config.AutoScaling getRevisionAutoScaling() {
        return this.revisionAutoScaling!=null?this.revisionAutoScaling.build():null;
    }

    public io.dekorate.knative.config.AutoScaling buildRevisionAutoScaling() {
        return this.revisionAutoScaling!=null?this.revisionAutoScaling.build():null;
    }

    public A withRevisionAutoScaling(io.dekorate.knative.config.AutoScaling revisionAutoScaling) {
        _visitables.get("revisionAutoScaling").remove(this.revisionAutoScaling);
        if (revisionAutoScaling!=null){ this.revisionAutoScaling= new AutoScalingBuilder(revisionAutoScaling); _visitables.get("revisionAutoScaling").add(this.revisionAutoScaling);} return (A) this;
    }

    public Boolean hasRevisionAutoScaling() {
        return this.revisionAutoScaling != null;
    }

    public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScaling() {
        return new RevisionAutoScalingNestedImpl();
    }

    public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScalingLike(io.dekorate.knative.config.AutoScaling item) {
        return new RevisionAutoScalingNestedImpl(item);
    }

    public KnativeConfigFluent.RevisionAutoScalingNested<A> editRevisionAutoScaling() {
        return withNewRevisionAutoScalingLike(getRevisionAutoScaling());
    }

    public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScaling() {
        return withNewRevisionAutoScalingLike(getRevisionAutoScaling() != null ? getRevisionAutoScaling(): new AutoScalingBuilder().build());
    }

    public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScalingLike(io.dekorate.knative.config.AutoScaling item) {
        return withNewRevisionAutoScalingLike(getRevisionAutoScaling() != null ? getRevisionAutoScaling(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGlobalAutoScaling instead.
 * @return The buildable object.
 */
@Deprecated public io.dekorate.knative.config.GlobalAutoScaling getGlobalAutoScaling() {
        return this.globalAutoScaling!=null?this.globalAutoScaling.build():null;
    }

    public io.dekorate.knative.config.GlobalAutoScaling buildGlobalAutoScaling() {
        return this.globalAutoScaling!=null?this.globalAutoScaling.build():null;
    }

    public A withGlobalAutoScaling(io.dekorate.knative.config.GlobalAutoScaling globalAutoScaling) {
        _visitables.get("globalAutoScaling").remove(this.globalAutoScaling);
        if (globalAutoScaling!=null){ this.globalAutoScaling= new GlobalAutoScalingBuilder(globalAutoScaling); _visitables.get("globalAutoScaling").add(this.globalAutoScaling);} return (A) this;
    }

    public Boolean hasGlobalAutoScaling() {
        return this.globalAutoScaling != null;
    }

    public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScaling() {
        return new GlobalAutoScalingNestedImpl();
    }

    public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScalingLike(io.dekorate.knative.config.GlobalAutoScaling item) {
        return new GlobalAutoScalingNestedImpl(item);
    }

    public KnativeConfigFluent.GlobalAutoScalingNested<A> editGlobalAutoScaling() {
        return withNewGlobalAutoScalingLike(getGlobalAutoScaling());
    }

    public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScaling() {
        return withNewGlobalAutoScalingLike(getGlobalAutoScaling() != null ? getGlobalAutoScaling(): new GlobalAutoScalingBuilder().build());
    }

    public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScalingLike(io.dekorate.knative.config.GlobalAutoScaling item) {
        return withNewGlobalAutoScalingLike(getGlobalAutoScaling() != null ? getGlobalAutoScaling(): item);
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public A withTemplateName(String templateName) {
        this.templateName=templateName; return (A) this;
    }

    public Boolean hasTemplateName() {
        return this.templateName != null;
    }

    public A withNewTemplateName(String arg1) {
        return (A)withTemplateName(new String(arg1));
    }

    public A withNewTemplateName(StringBuilder arg1) {
        return (A)withTemplateName(new String(arg1));
    }

    public A withNewTemplateName(StringBuffer arg1) {
        return (A)withTemplateName(new String(arg1));
    }

    public A withTraffic(io.dekorate.knative.config.Traffic... traffic) {
        if (this.traffic != null) {this.traffic.clear();}
        if (traffic != null) {for (io.dekorate.knative.config.Traffic item :traffic){ this.addToTraffic(item);}} return (A) this;
    }

    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 */
@Deprecated public io.dekorate.knative.config.Traffic[] getTraffic() {
        int size = traffic != null ? traffic.size() : 0;
io.dekorate.knative.config.Traffic[] result = new io.dekorate.knative.config.Traffic[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends io.dekorate.knative.config.Traffic,?> builder : traffic) {
    result[index++]=builder.build();
}
return result;

    }

    public io.dekorate.knative.config.Traffic[] buildTraffic() {
        int size = traffic != null ? traffic.size() : 0;
io.dekorate.knative.config.Traffic[] result = new io.dekorate.knative.config.Traffic[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends io.dekorate.knative.config.Traffic,?> builder : traffic) {
    result[index++]=builder.build();
}
return result;

    }

    public io.dekorate.knative.config.Traffic buildTraffic(int index) {
        return this.traffic.get(index).build();
    }

    public io.dekorate.knative.config.Traffic buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    public io.dekorate.knative.config.Traffic buildLastTraffic() {
        return this.traffic.get(traffic.size() - 1).build();
    }

    public io.dekorate.knative.config.Traffic buildMatchingTraffic(io.dekorate.deps.kubernetes.api.builder.Predicate<TrafficBuilder> predicate) {
        for (TrafficBuilder item: traffic) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTraffic(io.dekorate.deps.kubernetes.api.builder.Predicate<TrafficBuilder> predicate) {
        for (TrafficBuilder item: traffic) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A addToTraffic(int index,io.dekorate.knative.config.Traffic item) {
        if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
        io.dekorate.knative.config.TrafficBuilder builder = new io.dekorate.knative.config.TrafficBuilder(item);_visitables.get("traffic").add(index >= 0 ? index : _visitables.get("traffic").size(), builder);this.traffic.add(index >= 0 ? index : traffic.size(), builder); return (A)this;
    }

    public A setToTraffic(int index,io.dekorate.knative.config.Traffic item) {
        if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
        io.dekorate.knative.config.TrafficBuilder builder = new io.dekorate.knative.config.TrafficBuilder(item);
        if (index < 0 || index >= _visitables.get("traffic").size()) { _visitables.get("traffic").add(builder); } else { _visitables.get("traffic").set(index, builder);}
        if (index < 0 || index >= traffic.size()) { traffic.add(builder); } else { traffic.set(index, builder);}
         return (A)this;
    }

    public A addToTraffic(io.dekorate.knative.config.Traffic... items) {
        if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
        for (io.dekorate.knative.config.Traffic item : items) {io.dekorate.knative.config.TrafficBuilder builder = new io.dekorate.knative.config.TrafficBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A addAllToTraffic(Collection<io.dekorate.knative.config.Traffic> items) {
        if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
        for (io.dekorate.knative.config.Traffic item : items) {io.dekorate.knative.config.TrafficBuilder builder = new io.dekorate.knative.config.TrafficBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A removeFromTraffic(io.dekorate.knative.config.Traffic... items) {
        for (io.dekorate.knative.config.Traffic item : items) {io.dekorate.knative.config.TrafficBuilder builder = new io.dekorate.knative.config.TrafficBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeAllFromTraffic(Collection<io.dekorate.knative.config.Traffic> items) {
        for (io.dekorate.knative.config.Traffic item : items) {io.dekorate.knative.config.TrafficBuilder builder = new io.dekorate.knative.config.TrafficBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTraffic(io.dekorate.deps.kubernetes.api.builder.Predicate<TrafficBuilder> predicate) {
        if (traffic == null) return (A) this;
        final Iterator<TrafficBuilder> each = traffic.iterator();
        final List visitables = _visitables.get("traffic");
        while (each.hasNext()) {
          TrafficBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public Boolean hasTraffic() {
        return traffic != null && !traffic.isEmpty();
    }

    public A addNewTraffic(String tag,String revisionName,boolean latestRevision,int percentage) {
        return (A)addToTraffic(new Traffic(tag, revisionName, latestRevision, percentage));
    }

    public KnativeConfigFluent.TrafficNested<A> addNewTraffic() {
        return new TrafficNestedImpl();
    }

    public KnativeConfigFluent.TrafficNested<A> addNewTrafficLike(io.dekorate.knative.config.Traffic item) {
        return new TrafficNestedImpl(-1, item);
    }

    public KnativeConfigFluent.TrafficNested<A> setNewTrafficLike(int index,io.dekorate.knative.config.Traffic item) {
        return new TrafficNestedImpl(index, item);
    }

    public KnativeConfigFluent.TrafficNested<A> editTraffic(int index) {
        if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public KnativeConfigFluent.TrafficNested<A> editFirstTraffic() {
        if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
        return setNewTrafficLike(0, buildTraffic(0));
    }

    public KnativeConfigFluent.TrafficNested<A> editLastTraffic() {
        int index = traffic.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public KnativeConfigFluent.TrafficNested<A> editMatchingTraffic(io.dekorate.deps.kubernetes.api.builder.Predicate<TrafficBuilder> predicate) {
        int index = -1;
        for (int i=0;i<traffic.size();i++) { 
        if (predicate.apply(traffic.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KnativeConfigFluentImpl that = (KnativeConfigFluentImpl) o;
        if (revisionName != null ? !revisionName.equals(that.revisionName) :that.revisionName != null) return false;
        if (httpTransportVersion != null ? !httpTransportVersion.equals(that.httpTransportVersion) :that.httpTransportVersion != null) return false;
        if (minScale != that.minScale) return false;
        if (maxScale != that.maxScale) return false;
        if (scaleToZeroEnabled != that.scaleToZeroEnabled) return false;
        if (revisionAutoScaling != null ? !revisionAutoScaling.equals(that.revisionAutoScaling) :that.revisionAutoScaling != null) return false;
        if (globalAutoScaling != null ? !globalAutoScaling.equals(that.globalAutoScaling) :that.globalAutoScaling != null) return false;
        if (templateName != null ? !templateName.equals(that.templateName) :that.templateName != null) return false;
        if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(revisionName,  httpTransportVersion,  minScale,  maxScale,  scaleToZeroEnabled,  revisionAutoScaling,  globalAutoScaling,  templateName,  traffic,  super.hashCode());
    }

    public class RevisionAutoScalingNestedImpl<N> extends AutoScalingFluentImpl<KnativeConfigFluent.RevisionAutoScalingNested<N>> implements KnativeConfigFluent.RevisionAutoScalingNested<N>,io.dekorate.deps.kubernetes.api.builder.Nested<N> {
        private final AutoScalingBuilder builder;

        RevisionAutoScalingNestedImpl(io.dekorate.knative.config.AutoScaling item) {
            this.builder = new AutoScalingBuilder(this, item);
        }

        RevisionAutoScalingNestedImpl() {
            this.builder = new AutoScalingBuilder(this);
        }

        public N and() {
             return (N) KnativeConfigFluentImpl.this.withRevisionAutoScaling(builder.build());
        }

        public N endRevisionAutoScaling() {
             return and();
        }
    }


    public class GlobalAutoScalingNestedImpl<N> extends GlobalAutoScalingFluentImpl<KnativeConfigFluent.GlobalAutoScalingNested<N>> implements KnativeConfigFluent.GlobalAutoScalingNested<N>,io.dekorate.deps.kubernetes.api.builder.Nested<N> {
        private final GlobalAutoScalingBuilder builder;

        GlobalAutoScalingNestedImpl(io.dekorate.knative.config.GlobalAutoScaling item) {
            this.builder = new GlobalAutoScalingBuilder(this, item);
        }

        GlobalAutoScalingNestedImpl() {
            this.builder = new GlobalAutoScalingBuilder(this);
        }

        public N and() {
             return (N) KnativeConfigFluentImpl.this.withGlobalAutoScaling(builder.build());
        }

        public N endGlobalAutoScaling() {
             return and();
        }
    }


    public class TrafficNestedImpl<N> extends TrafficFluentImpl<KnativeConfigFluent.TrafficNested<N>> implements KnativeConfigFluent.TrafficNested<N>,io.dekorate.deps.kubernetes.api.builder.Nested<N> {
        private final TrafficBuilder builder;
        private final int index;

        TrafficNestedImpl(int index,io.dekorate.knative.config.Traffic item) {
            this.index = index;
            this.builder = new TrafficBuilder(this, item);
        }

        TrafficNestedImpl() {
            this.index = -1;
            this.builder = new TrafficBuilder(this);
        }

        public N and() {
             return (N) KnativeConfigFluentImpl.this.setToTraffic(index,builder.build());
        }

        public N endTraffic() {
             return and();
        }
    }


}
