package io.dekorate.knative.config;

import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class Traffic {

    private String tag = "";
    private String revisionName = "";
    private boolean latestRevision = false;
    private int percentage = 100;

    public Traffic() { 
    }


    public Traffic(String tag,String revisionName,boolean latestRevision,int percentage) { 
        this.tag = tag != null ? tag : "";
        this.revisionName = revisionName != null ? revisionName : "";
        this.latestRevision = latestRevision;
        this.percentage = percentage;
    }


    public String getTag() {
        return this.tag;
    }

    public String getRevisionName() {
        return this.revisionName;
    }

    public boolean isLatestRevision() {
        return this.latestRevision;
    }

    public int getPercentage() {
        return this.percentage;
    }

    public static TrafficBuilder newBuilder() {
        return new io.dekorate.knative.config.TrafficBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Traffic that = (Traffic) o;
        if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
        if (revisionName != null ? !revisionName.equals(that.revisionName) :that.revisionName != null) return false;
        if (latestRevision != that.latestRevision) return false;
        if (percentage != that.percentage) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(tag,  revisionName,  latestRevision,  percentage,  super.hashCode());
    }

}
