package io.dekorate.knative.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TrafficBuilder extends TrafficFluentImpl<TrafficBuilder> implements VisitableBuilder<io.dekorate.knative.config.Traffic,TrafficBuilder> {

    TrafficFluent<?> fluent;
    Boolean validationEnabled;

    public TrafficBuilder() { 
        this(true);
    }


    public TrafficBuilder(Boolean validationEnabled) { 
        this(new Traffic(), validationEnabled);
    }


    public TrafficBuilder(TrafficFluent<?> fluent) { 
        this(fluent, true);
    }


    public TrafficBuilder(TrafficFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Traffic(), validationEnabled);
    }


    public TrafficBuilder(TrafficFluent<?> fluent,io.dekorate.knative.config.Traffic instance) { 
        this(fluent, instance, true);
    }


    public TrafficBuilder(TrafficFluent<?> fluent,io.dekorate.knative.config.Traffic instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withTag(instance.getTag()); 
        fluent.withRevisionName(instance.getRevisionName()); 
        fluent.withLatestRevision(instance.isLatestRevision()); 
        fluent.withPercentage(instance.getPercentage()); 
        this.validationEnabled = validationEnabled; 
    }


    public TrafficBuilder(io.dekorate.knative.config.Traffic instance) { 
        this(instance,true);
    }


    public TrafficBuilder(io.dekorate.knative.config.Traffic instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withTag(instance.getTag()); 
        this.withRevisionName(instance.getRevisionName()); 
        this.withLatestRevision(instance.isLatestRevision()); 
        this.withPercentage(instance.getPercentage()); 
        this.validationEnabled = validationEnabled; 
    }


    public EditableTraffic build() {
        EditableTraffic buildable = new EditableTraffic(fluent.getTag(),fluent.getRevisionName(),fluent.isLatestRevision(),fluent.getPercentage());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TrafficBuilder that = (TrafficBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
