package io.dekorate.knative.config;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class TrafficFluentImpl<A extends TrafficFluent<A>> extends BaseFluent<A> implements TrafficFluent<A> {

    private String tag = "";
    private String revisionName = "";
    private boolean latestRevision = false;
    private int percentage = 100;

    public TrafficFluentImpl() { 
    }


    public TrafficFluentImpl(io.dekorate.knative.config.Traffic instance) { 
        this.withTag(instance.getTag()); 
        this.withRevisionName(instance.getRevisionName()); 
        this.withLatestRevision(instance.isLatestRevision()); 
        this.withPercentage(instance.getPercentage()); 
    }


    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag=tag; return (A) this;
    }

    public Boolean hasTag() {
        return this.tag != null;
    }

    public A withNewTag(String arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuilder arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuffer arg1) {
        return (A)withTag(new String(arg1));
    }

    public String getRevisionName() {
        return this.revisionName;
    }

    public A withRevisionName(String revisionName) {
        this.revisionName=revisionName; return (A) this;
    }

    public Boolean hasRevisionName() {
        return this.revisionName != null;
    }

    public A withNewRevisionName(String arg1) {
        return (A)withRevisionName(new String(arg1));
    }

    public A withNewRevisionName(StringBuilder arg1) {
        return (A)withRevisionName(new String(arg1));
    }

    public A withNewRevisionName(StringBuffer arg1) {
        return (A)withRevisionName(new String(arg1));
    }

    public boolean isLatestRevision() {
        return this.latestRevision;
    }

    public A withLatestRevision(boolean latestRevision) {
        this.latestRevision=latestRevision; return (A) this;
    }

    public Boolean hasLatestRevision() {
        return true;
    }

    public int getPercentage() {
        return this.percentage;
    }

    public A withPercentage(int percentage) {
        this.percentage=percentage; return (A) this;
    }

    public Boolean hasPercentage() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TrafficFluentImpl that = (TrafficFluentImpl) o;
        if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
        if (revisionName != null ? !revisionName.equals(that.revisionName) :that.revisionName != null) return false;
        if (latestRevision != that.latestRevision) return false;
        if (percentage != that.percentage) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(tag,  revisionName,  latestRevision,  percentage,  super.hashCode());
    }

}
