/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.config;

import io.dekorate.knative.config.AutoScalerClass;
import io.dekorate.knative.config.GlobalAutoScalingBuilder;
import java.util.Objects;

public class GlobalAutoScaling {
    private AutoScalerClass autoScalerClass = AutoScalerClass.kpa;
    private int containerConcurrency = 0;
    private int targetUtilizationPercentage = 70;
    private int requestsPerSecond = 200;

    public GlobalAutoScaling() {
    }

    public GlobalAutoScaling(AutoScalerClass autoScalerClass, int containerConcurrency, int targetUtilizationPercentage, int requestsPerSecond) {
        this.autoScalerClass = autoScalerClass != null ? autoScalerClass : AutoScalerClass.kpa;
        this.containerConcurrency = containerConcurrency;
        this.targetUtilizationPercentage = targetUtilizationPercentage;
        this.requestsPerSecond = requestsPerSecond;
    }

    public AutoScalerClass getAutoScalerClass() {
        return this.autoScalerClass;
    }

    public int getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public int getTargetUtilizationPercentage() {
        return this.targetUtilizationPercentage;
    }

    public int getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public static GlobalAutoScalingBuilder newBuilder() {
        return new GlobalAutoScalingBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalAutoScaling that = (GlobalAutoScaling)o;
        if (this.autoScalerClass != null ? !this.autoScalerClass.equals((Object)that.autoScalerClass) : that.autoScalerClass != null) {
            return false;
        }
        if (this.containerConcurrency != that.containerConcurrency) {
            return false;
        }
        if (this.targetUtilizationPercentage != that.targetUtilizationPercentage) {
            return false;
        }
        return this.requestsPerSecond == that.requestsPerSecond;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoScalerClass, this.containerConcurrency, this.targetUtilizationPercentage, this.requestsPerSecond, super.hashCode()});
    }
}

