/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.decorator;

import io.dekorate.deps.knative.serving.v1.RevisionSpecFluent;
import io.dekorate.deps.kubernetes.api.model.HostAliasBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AddHostAliasesToRevisionDecorator
extends NamedResourceDecorator<RevisionSpecFluent<?>> {
    private final HostAlias hostAlias;

    public AddHostAliasesToRevisionDecorator(HostAlias hostAlias) {
        this(ANY, hostAlias);
    }

    public AddHostAliasesToRevisionDecorator(String deploymentName, HostAlias hostAlias) {
        super(deploymentName);
        this.hostAlias = hostAlias;
    }

    public void andThenVisit(RevisionSpecFluent<?> revisionSpec, ObjectMeta resourceMeta) {
        if (Strings.isNotNullOrEmpty((String)this.hostAlias.getIp()) && Strings.isNotNullOrEmpty((String)this.hostAlias.getHostnames())) {
            List<Object> existing = revisionSpec.getHostAliases();
            if (existing == null) {
                existing = new ArrayList();
            }
            existing = existing.stream().filter(h -> !h.getIp().equals(this.hostAlias.getIp())).collect(Collectors.toList());
            ArrayList<io.dekorate.deps.kubernetes.api.model.HostAlias> updated = new ArrayList<io.dekorate.deps.kubernetes.api.model.HostAlias>(existing);
            updated.add(((HostAliasBuilder)((HostAliasBuilder)new HostAliasBuilder().withIp(this.hostAlias.getIp())).withHostnames(Arrays.asList(this.hostAlias.getHostnames().split(",")))).build());
            revisionSpec.withHostAliases(updated);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddHostAliasesToRevisionDecorator that = (AddHostAliasesToRevisionDecorator)((Object)o);
        return Objects.equals(this.hostAlias, that.hostAlias);
    }

    public int hashCode() {
        return Objects.hash(this.hostAlias);
    }
}

