/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.manifest;

import io.dekorate.AbstractKubernetesManifestGenerator;
import io.dekorate.ConfigurationRegistry;
import io.dekorate.ResourceRegistry;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.knative.config.AutoScalerClass;
import io.dekorate.knative.config.AutoscalingMetric;
import io.dekorate.knative.config.EditableKnativeConfig;
import io.dekorate.knative.config.GlobalAutoScaling;
import io.dekorate.knative.config.KnativeConfig;
import io.dekorate.knative.config.KnativeConfigBuilder;
import io.dekorate.knative.config.Traffic;
import io.dekorate.knative.decorator.AddAwsElasticBlockStoreVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddAzureDiskVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddAzureFileVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddConfigMapVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddHostAliasesToRevisionDecorator;
import io.dekorate.knative.decorator.AddPvcVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddSecretVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddSidecarToRevisionDecorator;
import io.dekorate.knative.decorator.ApplyGlobalAutoscalingClassDecorator;
import io.dekorate.knative.decorator.ApplyGlobalContainerConcurrencyDecorator;
import io.dekorate.knative.decorator.ApplyGlobalRequestsPerSecondTargetDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingClassDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingMetricDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingTargetDecorator;
import io.dekorate.knative.decorator.ApplyLocalContainerConcurrencyDecorator;
import io.dekorate.knative.decorator.ApplyLocalTargetUtilizationPercentageDecorator;
import io.dekorate.knative.decorator.ApplyMaxScaleDecorator;
import io.dekorate.knative.decorator.ApplyMinScaleDecorator;
import io.dekorate.knative.decorator.ApplyRevisionNameDecorator;
import io.dekorate.knative.decorator.ApplyServiceAccountToRevisionSpecDecorator;
import io.dekorate.knative.decorator.ApplyTrafficDecorator;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelBuilder;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddCommitIdAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapDataDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapResourceProvidingDecorator;
import io.dekorate.kubernetes.decorator.AddImagePullSecretToServiceAccountDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountResourceDecorator;
import io.dekorate.kubernetes.decorator.AddVcsUrlAnnotationDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyPortNameDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.option.config.VcsConfig;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Git;
import io.dekorate.utils.Images;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import io.fabric8.knative.serving.v1.RevisionSpecFluent;
import io.fabric8.knative.serving.v1.RevisionTemplateSpecFluent;
import io.fabric8.knative.serving.v1.Service;
import io.fabric8.knative.serving.v1.ServiceBuilder;
import io.fabric8.knative.serving.v1.ServiceFluent;
import io.fabric8.knative.serving.v1.ServiceSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;

public class KnativeManifestGenerator
extends AbstractKubernetesManifestGenerator<KnativeConfig> {
    private static final String KNATIVE = "knative";
    private static final String KNATIVE_SERVING = "knative-serving";
    private static final String CONFIG_AUTOSCALER = "config-autoscaler";
    private static final String CONFIG_DEFAULTS = "config-defaults";
    private static final String DEFAULT_REGISTRY = "dev.local/";
    private static final String KNATIVE_VISIBILITY = "networking.knative.dev/visibility";
    private static final String CLUSTER_LOCAL = "cluster-local";

    public KnativeManifestGenerator() {
        this(new ResourceRegistry(), new ConfigurationRegistry());
    }

    public KnativeManifestGenerator(ResourceRegistry resourceRegistry, ConfigurationRegistry configurationRegistry) {
        super(resourceRegistry, configurationRegistry);
    }

    public int order() {
        return 400;
    }

    public String getKey() {
        return KNATIVE;
    }

    public void generate(KnativeConfig config) {
        Optional<Service> existingService = this.resourceRegistry.groups().getOrDefault(KNATIVE, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof Service).map(i -> (Service)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingService.isPresent()) {
            this.resourceRegistry.add(KNATIVE, (HasMetadata)this.createService(config));
        }
        Project project = this.getProject();
        Optional vcsConfig = this.configurationRegistry.get(VcsConfig.class);
        String remote = vcsConfig.map(VcsConfig::getRemote).orElse("origin");
        boolean httpsPrefered = vcsConfig.map(VcsConfig::isHttpsPreferred).orElse(false);
        String vcsUrl = project.getScmInfo() != null && Strings.isNotNullOrEmpty((String)((String)project.getScmInfo().getRemote().get("origin"))) ? Git.getRemoteUrl((Path)project.getRoot(), (String)remote, (boolean)httpsPrefered).orElse("<<unknown>>") : "<<unknown>>";
        this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddVcsUrlAnnotationDecorator(config.getName(), "app.dekorate.io/vcs-url", vcsUrl));
        this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddCommitIdAnnotationDecorator());
        this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyPortNameDecorator(null, null, config.getHttpTransportVersion() != null ? config.getHttpTransportVersion().name().toLowerCase() : "http1", Ports.webPortNames().toArray(new String[Ports.webPortNames().size()])));
        this.addDecorators(KNATIVE, config);
        if (config.getMinScale() != null && config.getMinScale() != 0) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyMinScaleDecorator(config.getName(), config.getMinScale()));
        }
        if (config.getMaxScale() != null && config.getMaxScale() != 0) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyMaxScaleDecorator(config.getName(), config.getMaxScale()));
        }
        if (!config.isScaleToZeroEnabled()) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddConfigMapResourceProvidingDecorator(CONFIG_AUTOSCALER, KNATIVE_SERVING));
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddConfigMapDataDecorator(CONFIG_AUTOSCALER, new String[]{"enable-scale-to-zero", String.valueOf(config.isScaleToZeroEnabled())}));
        }
        if (Strings.isNotNullOrEmpty((String)config.getRevisionName())) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyRevisionNameDecorator(config.getName(), config.getRevisionName()));
        }
        if (config.getRevisionAutoScaling() != null) {
            if (config.getRevisionAutoScaling().getMetric() != null && config.getRevisionAutoScaling().getMetric() != AutoscalingMetric.concurrency) {
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyLocalAutoscalingMetricDecorator(config.getName(), config.getRevisionAutoScaling().getMetric()));
            }
            if (config.getRevisionAutoScaling().getAutoScalerClass() != null && config.getRevisionAutoScaling().getAutoScalerClass() != AutoScalerClass.kpa) {
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyLocalAutoscalingClassDecorator(config.getName(), config.getRevisionAutoScaling().getAutoScalerClass()));
            }
            if (config.getRevisionAutoScaling().getTarget() != null && config.getRevisionAutoScaling().getTarget() != 0) {
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyLocalAutoscalingTargetDecorator(config.getName(), config.getRevisionAutoScaling().getTarget()));
            }
            if (config.getRevisionAutoScaling().getContainerConcurrency() != null && config.getRevisionAutoScaling().getContainerConcurrency() != 0) {
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyLocalContainerConcurrencyDecorator(config.getName(), config.getRevisionAutoScaling().getContainerConcurrency().intValue()));
            }
            if (config.getRevisionAutoScaling().getTarget() != null && config.getRevisionAutoScaling().getTarget() != 200 && config.getRevisionAutoScaling().getMetric() == AutoscalingMetric.rps) {
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyLocalContainerConcurrencyDecorator(config.getName(), config.getRevisionAutoScaling().getTarget().intValue()));
            }
            if (config.getRevisionAutoScaling().getTargetUtilizationPercentage() != null && config.getRevisionAutoScaling().getTargetUtilizationPercentage() != 70) {
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyLocalTargetUtilizationPercentageDecorator(config.getName(), config.getRevisionAutoScaling().getTargetUtilizationPercentage()));
            }
        }
        if (config.getGlobalAutoScaling() != null) {
            if (!KnativeManifestGenerator.isDefault(config.getGlobalAutoScaling())) {
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddConfigMapResourceProvidingDecorator(CONFIG_AUTOSCALER, KNATIVE_SERVING));
                if (config.getGlobalAutoScaling().getAutoScalerClass() != null && config.getGlobalAutoScaling().getAutoScalerClass() != AutoScalerClass.kpa) {
                    this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyGlobalAutoscalingClassDecorator(config.getGlobalAutoScaling().getAutoScalerClass()));
                }
                if (config.getGlobalAutoScaling().getRequestsPerSecond() != null && config.getGlobalAutoScaling().getRequestsPerSecond() != 200) {
                    this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyGlobalRequestsPerSecondTargetDecorator(config.getGlobalAutoScaling().getRequestsPerSecond()));
                }
                if (config.getGlobalAutoScaling().getTargetUtilizationPercentage() != null && config.getGlobalAutoScaling().getTargetUtilizationPercentage() != 70) {
                    this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyGlobalContainerConcurrencyDecorator(config.getGlobalAutoScaling().getTargetUtilizationPercentage()));
                }
            }
            if (config.getGlobalAutoScaling().getContainerConcurrency() != null && config.getGlobalAutoScaling().getContainerConcurrency() != 0) {
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddConfigMapResourceProvidingDecorator(CONFIG_DEFAULTS, KNATIVE_SERVING));
                this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyGlobalContainerConcurrencyDecorator(config.getGlobalAutoScaling().getContainerConcurrency()));
            }
        }
        for (Traffic traffic : config.getTraffic()) {
            String revisionName = Strings.isNotNullOrEmpty((String)config.getRevisionName()) ? config.getRevisionName() : null;
            String tag = Strings.isNotNullOrEmpty((String)traffic.getTag()) ? traffic.getTag() : null;
            boolean latestRevision = revisionName == null ? true : traffic.isLatestRevision();
            long percentage = traffic.getPercentage().intValue();
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new ApplyTrafficDecorator(config.getName(), revisionName, latestRevision, percentage, tag));
        }
        for (Traffic traffic : config.getSidecars()) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddSidecarToRevisionDecorator(config.getName(), (Container)traffic));
        }
        for (Traffic traffic : config.getSecretVolumes()) {
            KnativeManifestGenerator.validateVolume((SecretVolume)traffic);
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddSecretVolumeToRevisionDecorator((SecretVolume)traffic));
        }
        for (Traffic traffic : config.getConfigMapVolumes()) {
            KnativeManifestGenerator.validateVolume((ConfigMapVolume)traffic);
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddConfigMapVolumeToRevisionDecorator((ConfigMapVolume)traffic));
        }
        for (Traffic traffic : config.getPvcVolumes()) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddPvcVolumeToRevisionDecorator((PersistentVolumeClaimVolume)traffic));
        }
        for (Traffic traffic : config.getAzureFileVolumes()) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddAzureFileVolumeToRevisionDecorator((AzureFileVolume)traffic));
        }
        for (Traffic traffic : config.getAzureDiskVolumes()) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddAzureDiskVolumeToRevisionDecorator((AzureDiskVolume)traffic));
        }
        for (Traffic traffic : config.getAwsElasticBlockStoreVolumes()) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddAwsElasticBlockStoreVolumeToRevisionDecorator((AwsElasticBlockStoreVolume)traffic));
        }
        for (Traffic traffic : config.getHostAliases()) {
            this.resourceRegistry.decorate(KNATIVE, (Decorator)new AddHostAliasesToRevisionDecorator((HostAlias)traffic));
        }
    }

    public ConfigurationSupplier<KnativeConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((KnativeConfigBuilder)new KnativeConfigBuilder().accept(new Visitor[]{new ApplyDeployToApplicationConfiguration()})).accept(new Visitor[]{new ApplyProjectInfo(p)}));
    }

    protected void addDecorators(String group, KnativeConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        this.resourceRegistry.decorate(group, (Decorator)new ApplyImagePullPolicyDecorator(config.getImagePullPolicy()));
        if (!config.isExpose()) {
            this.resourceRegistry.decorate(group, (Decorator)new AddLabelDecorator(config.getName(), (Label)((LabelBuilder)((LabelBuilder)new LabelBuilder().withKey(KNATIVE_VISIBILITY)).withValue(CLUSTER_LOCAL)).build()));
        }
        if (config.getImagePullSecrets() != null && config.getImagePullSecrets().length != 0) {
            String serviceAccount = Strings.isNotNullOrEmpty((String)config.getServiceAccount()) ? config.getServiceAccount() : config.getName();
            this.resourceRegistry.decorate(group, (Decorator)new AddServiceAccountResourceDecorator(config.getName(), serviceAccount));
            this.resourceRegistry.decorate(group, (Decorator)new ApplyServiceAccountToRevisionSpecDecorator(config.getName(), serviceAccount));
            this.resourceRegistry.decorate(group, (Decorator)new AddImagePullSecretToServiceAccountDecorator(serviceAccount, Arrays.asList(config.getImagePullSecrets())));
        }
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(KnativeConfig.class) || type.equals(EditableKnativeConfig.class);
    }

    public Service createService(KnativeConfig config) {
        ImageConfiguration imageConfig = this.getImageConfiguration(config);
        String image = Strings.isNotNullOrEmpty((String)imageConfig.getImage()) ? imageConfig.getImage() : Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.TemplateNested)((RevisionTemplateSpecFluent.SpecNested)((RevisionSpecFluent.ContainersNested)((RevisionSpecFluent.ContainersNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(config.getName())).endMetadata()).withNewSpec().withNewTemplate().withNewSpec().addNewContainer().withName(config.getName())).withImage(image)).endContainer()).endSpec()).endTemplate()).endSpec()).build();
    }

    public static boolean isDefault(GlobalAutoScaling autoScaling) {
        if (autoScaling.getAutoScalerClass() != AutoScalerClass.kpa) {
            return false;
        }
        if (autoScaling.getContainerConcurrency() != 0) {
            return false;
        }
        if (autoScaling.getRequestsPerSecond() != 200) {
            return false;
        }
        return autoScaling.getTargetUtilizationPercentage() == 70;
    }
}

