/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.listener;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceFactories;
import io.dekorate.DekorateException;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.hook.ImageBuildHook;
import io.dekorate.knative.config.KnativeConfig;
import io.dekorate.project.Project;
import io.fabric8.kubernetes.api.model.KubernetesList;
import java.util.Collection;
import java.util.Optional;

public class KnativeSessionListener
implements SessionListener,
WithProject,
WithSession {
    private static final String KNATIVE = "knative";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Session session = this.getSession();
            Project project = this.getProject();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            KnativeConfig config = (KnativeConfig)((Object)session.getConfigurationRegistry().get(KnativeConfig.class).get());
            Optional imageConfiguration = session.getConfigurationRegistry().getImageConfig(BuildServiceFactories.supplierMatches((Project)project));
            imageConfiguration.ifPresent(i -> {
                String name = i.getName();
                if (i.isAutoBuildEnabled() || config.isAutoDeployEnabled()) {
                    BuildService buildService;
                    KubernetesList generated = (KubernetesList)session.getGeneratedResources().get(KNATIVE);
                    try {
                        buildService = (BuildService)imageConfiguration.map(BuildServiceFactories.create((Project)this.getProject(), (Collection)generated.getItems())).orElseThrow(() -> new IllegalStateException("No applicable BuildServiceFactory found."));
                    }
                    catch (Exception e) {
                        throw DekorateException.launderThrowable((String)"Failed to lookup BuildService.", (Throwable)e);
                    }
                    ImageBuildHook hook = new ImageBuildHook(this.getProject(), buildService);
                    hook.register();
                }
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

