/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.config;

import io.dekorate.knative.config.AutoScaling;
import io.dekorate.knative.config.AutoScalingBuilder;
import io.dekorate.knative.config.AutoScalingFluent;
import io.dekorate.knative.config.GlobalAutoScaling;
import io.dekorate.knative.config.GlobalAutoScalingBuilder;
import io.dekorate.knative.config.GlobalAutoScalingFluent;
import io.dekorate.knative.config.HttpTransportVersion;
import io.dekorate.knative.config.KnativeConfig;
import io.dekorate.knative.config.Traffic;
import io.dekorate.knative.config.TrafficBuilder;
import io.dekorate.knative.config.TrafficFluent;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KnativeConfigFluent<A extends KnativeConfigFluent<A>>
extends BaseConfigFluent<A> {
    private String revisionName;
    private String host;
    private HttpTransportVersion httpTransportVersion;
    private Boolean expose;
    private Integer minScale;
    private Integer maxScale;
    private Boolean scaleToZeroEnabled;
    private AutoScalingBuilder revisionAutoScaling;
    private GlobalAutoScalingBuilder globalAutoScaling;
    private String templateName;
    private ArrayList<TrafficBuilder> traffic = new ArrayList();

    public KnativeConfigFluent() {
    }

    public KnativeConfigFluent(KnativeConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KnativeConfig instance) {
        KnativeConfig knativeConfig = instance = instance != null ? instance : new KnativeConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withPartOf(instance.getPartOf());
            this.withName(instance.getName());
            this.withVersion(instance.getVersion());
            this.withDeploymentKind(instance.getDeploymentKind());
            this.withLabels(instance.getLabels());
            this.withAnnotations(instance.getAnnotations());
            this.withEnvVars(instance.getEnvVars());
            this.withWorkingDir(instance.getWorkingDir());
            this.withCommand(instance.getCommand());
            this.withArguments(instance.getArguments());
            this.withServiceAccount(instance.getServiceAccount());
            this.withPorts(instance.getPorts());
            this.withServiceType(instance.getServiceType());
            this.withPvcVolumes(instance.getPvcVolumes());
            this.withSecretVolumes(instance.getSecretVolumes());
            this.withConfigMapVolumes(instance.getConfigMapVolumes());
            this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
            this.withGitRepoVolumes(instance.getGitRepoVolumes());
            this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
            this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
            this.withAzureFileVolumes(instance.getAzureFileVolumes());
            this.withMounts(instance.getMounts());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withDeploymentStrategy(instance.getDeploymentStrategy());
            this.withRollingUpdate(instance.getRollingUpdate());
            this.withHostAliases(instance.getHostAliases());
            this.withNodeSelector(instance.getNodeSelector());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withStartupProbe(instance.getStartupProbe());
            this.withRequestResources(instance.getRequestResources());
            this.withLimitResources(instance.getLimitResources());
            this.withSidecars(instance.getSidecars());
            this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
            this.withJobs(instance.getJobs());
            this.withCronJobs(instance.getCronJobs());
            this.withRevisionName(instance.getRevisionName());
            this.withHost(instance.getHost());
            this.withHttpTransportVersion(instance.getHttpTransportVersion());
            this.withExpose(instance.getExpose());
            this.withMinScale(instance.getMinScale());
            this.withMaxScale(instance.getMaxScale());
            this.withScaleToZeroEnabled(instance.getScaleToZeroEnabled());
            this.withRevisionAutoScaling(instance.getRevisionAutoScaling());
            this.withGlobalAutoScaling(instance.getGlobalAutoScaling());
            this.withTemplateName(instance.getTemplateName());
            this.withTraffic(instance.getTraffic());
        }
    }

    public String getRevisionName() {
        return this.revisionName;
    }

    public A withRevisionName(String revisionName) {
        this.revisionName = revisionName;
        return (A)((Object)this);
    }

    public boolean hasRevisionName() {
        return this.revisionName != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public HttpTransportVersion getHttpTransportVersion() {
        return this.httpTransportVersion;
    }

    public A withHttpTransportVersion(HttpTransportVersion httpTransportVersion) {
        this.httpTransportVersion = httpTransportVersion;
        return (A)((Object)this);
    }

    public boolean hasHttpTransportVersion() {
        return this.httpTransportVersion != null;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public A withExpose(Boolean expose) {
        this.expose = expose;
        return (A)((Object)this);
    }

    public boolean hasExpose() {
        return this.expose != null;
    }

    public Integer getMinScale() {
        return this.minScale;
    }

    public A withMinScale(Integer minScale) {
        this.minScale = minScale;
        return (A)((Object)this);
    }

    public boolean hasMinScale() {
        return this.minScale != null;
    }

    public Integer getMaxScale() {
        return this.maxScale;
    }

    public A withMaxScale(Integer maxScale) {
        this.maxScale = maxScale;
        return (A)((Object)this);
    }

    public boolean hasMaxScale() {
        return this.maxScale != null;
    }

    public Boolean getScaleToZeroEnabled() {
        return this.scaleToZeroEnabled;
    }

    public A withScaleToZeroEnabled(Boolean scaleToZeroEnabled) {
        this.scaleToZeroEnabled = scaleToZeroEnabled;
        return (A)((Object)this);
    }

    public boolean hasScaleToZeroEnabled() {
        return this.scaleToZeroEnabled != null;
    }

    public AutoScaling buildRevisionAutoScaling() {
        return this.revisionAutoScaling != null ? this.revisionAutoScaling.build() : null;
    }

    public A withRevisionAutoScaling(AutoScaling revisionAutoScaling) {
        this._visitables.remove((Object)"revisionAutoScaling");
        if (revisionAutoScaling != null) {
            this.revisionAutoScaling = new AutoScalingBuilder(revisionAutoScaling);
            this._visitables.get((Object)"revisionAutoScaling").add(this.revisionAutoScaling);
        } else {
            this.revisionAutoScaling = null;
            this._visitables.get((Object)"revisionAutoScaling").remove((Object)this.revisionAutoScaling);
        }
        return (A)((Object)this);
    }

    public boolean hasRevisionAutoScaling() {
        return this.revisionAutoScaling != null;
    }

    public RevisionAutoScalingNested<A> withNewRevisionAutoScaling() {
        return new RevisionAutoScalingNested(null);
    }

    public RevisionAutoScalingNested<A> withNewRevisionAutoScalingLike(AutoScaling item) {
        return new RevisionAutoScalingNested(item);
    }

    public RevisionAutoScalingNested<A> editRevisionAutoScaling() {
        return this.withNewRevisionAutoScalingLike(Optional.ofNullable(this.buildRevisionAutoScaling()).orElse(null));
    }

    public RevisionAutoScalingNested<A> editOrNewRevisionAutoScaling() {
        return this.withNewRevisionAutoScalingLike(Optional.ofNullable(this.buildRevisionAutoScaling()).orElse(new AutoScalingBuilder().build()));
    }

    public RevisionAutoScalingNested<A> editOrNewRevisionAutoScalingLike(AutoScaling item) {
        return this.withNewRevisionAutoScalingLike(Optional.ofNullable(this.buildRevisionAutoScaling()).orElse(item));
    }

    public GlobalAutoScaling buildGlobalAutoScaling() {
        return this.globalAutoScaling != null ? this.globalAutoScaling.build() : null;
    }

    public A withGlobalAutoScaling(GlobalAutoScaling globalAutoScaling) {
        this._visitables.remove((Object)"globalAutoScaling");
        if (globalAutoScaling != null) {
            this.globalAutoScaling = new GlobalAutoScalingBuilder(globalAutoScaling);
            this._visitables.get((Object)"globalAutoScaling").add(this.globalAutoScaling);
        } else {
            this.globalAutoScaling = null;
            this._visitables.get((Object)"globalAutoScaling").remove((Object)this.globalAutoScaling);
        }
        return (A)((Object)this);
    }

    public boolean hasGlobalAutoScaling() {
        return this.globalAutoScaling != null;
    }

    public GlobalAutoScalingNested<A> withNewGlobalAutoScaling() {
        return new GlobalAutoScalingNested(null);
    }

    public GlobalAutoScalingNested<A> withNewGlobalAutoScalingLike(GlobalAutoScaling item) {
        return new GlobalAutoScalingNested(item);
    }

    public GlobalAutoScalingNested<A> editGlobalAutoScaling() {
        return this.withNewGlobalAutoScalingLike(Optional.ofNullable(this.buildGlobalAutoScaling()).orElse(null));
    }

    public GlobalAutoScalingNested<A> editOrNewGlobalAutoScaling() {
        return this.withNewGlobalAutoScalingLike(Optional.ofNullable(this.buildGlobalAutoScaling()).orElse(new GlobalAutoScalingBuilder().build()));
    }

    public GlobalAutoScalingNested<A> editOrNewGlobalAutoScalingLike(GlobalAutoScaling item) {
        return this.withNewGlobalAutoScalingLike(Optional.ofNullable(this.buildGlobalAutoScaling()).orElse(item));
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public A withTemplateName(String templateName) {
        this.templateName = templateName;
        return (A)((Object)this);
    }

    public boolean hasTemplateName() {
        return this.templateName != null;
    }

    public A withTraffic(Traffic ... traffic) {
        if (this.traffic != null) {
            this.traffic.clear();
            this._visitables.remove((Object)"traffic");
        }
        if (traffic != null) {
            for (Traffic item : traffic) {
                this.addToTraffic(item);
            }
        }
        return (A)((Object)this);
    }

    public Traffic[] buildTraffic() {
        int size = this.traffic != null ? this.traffic.size() : 0;
        Traffic[] result = new Traffic[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.traffic) {
            result[index++] = (Traffic)visitableBuilder.build();
        }
        return result;
    }

    public Traffic buildTraffic(int index) {
        return this.traffic.get(index).build();
    }

    public Traffic buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    public Traffic buildLastTraffic() {
        return this.traffic.get(this.traffic.size() - 1).build();
    }

    public Traffic buildMatchingTraffic(Predicate<TrafficBuilder> predicate) {
        for (TrafficBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTraffic(Predicate<TrafficBuilder> predicate) {
        for (TrafficBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToTraffic(int index, Traffic item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        TrafficBuilder builder = new TrafficBuilder(item);
        if (index < 0 || index >= this.traffic.size()) {
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        } else {
            this._visitables.get((Object)"traffic").add(index, builder);
            this.traffic.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTraffic(int index, Traffic item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        TrafficBuilder builder = new TrafficBuilder(item);
        if (index < 0 || index >= this.traffic.size()) {
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        } else {
            this._visitables.get((Object)"traffic").set(index, builder);
            this.traffic.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTraffic(Traffic ... items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        for (Traffic item : items) {
            TrafficBuilder builder = new TrafficBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTraffic(Collection<Traffic> items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        for (Traffic item : items) {
            TrafficBuilder builder = new TrafficBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTraffic(Traffic ... items) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        for (Traffic item : items) {
            TrafficBuilder builder = new TrafficBuilder(item);
            this._visitables.get((Object)"traffic").remove((Object)builder);
            this.traffic.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTraffic(Collection<Traffic> items) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        for (Traffic item : items) {
            TrafficBuilder builder = new TrafficBuilder(item);
            this._visitables.get((Object)"traffic").remove((Object)builder);
            this.traffic.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTraffic(Predicate<TrafficBuilder> predicate) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        Iterator<TrafficBuilder> each = this.traffic.iterator();
        List visitables = this._visitables.get((Object)"traffic");
        while (each.hasNext()) {
            TrafficBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasTraffic() {
        return this.traffic != null && !this.traffic.isEmpty();
    }

    public A addNewTraffic(String tag, String revisionName, Boolean latestRevision, Integer percentage) {
        return this.addToTraffic(new Traffic(tag, revisionName, latestRevision, percentage));
    }

    public TrafficNested<A> addNewTraffic() {
        return new TrafficNested(-1, null);
    }

    public TrafficNested<A> addNewTrafficLike(Traffic item) {
        return new TrafficNested(-1, item);
    }

    public TrafficNested<A> setNewTrafficLike(int index, Traffic item) {
        return new TrafficNested(index, item);
    }

    public TrafficNested<A> editTraffic(int index) {
        if (this.traffic.size() <= index) {
            throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public TrafficNested<A> editFirstTraffic() {
        if (this.traffic.size() == 0) {
            throw new RuntimeException("Can't edit first traffic. The list is empty.");
        }
        return this.setNewTrafficLike(0, this.buildTraffic(0));
    }

    public TrafficNested<A> editLastTraffic() {
        int index = this.traffic.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last traffic. The list is empty.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public TrafficNested<A> editMatchingTraffic(Predicate<TrafficBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.traffic.size(); ++i) {
            if (!predicate.test(this.traffic.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching traffic. No match found.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnativeConfigFluent that = (KnativeConfigFluent)((Object)o);
        if (!Objects.equals(this.revisionName, that.revisionName)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpTransportVersion, (Object)that.httpTransportVersion)) {
            return false;
        }
        if (!Objects.equals(this.expose, that.expose)) {
            return false;
        }
        if (!Objects.equals(this.minScale, that.minScale)) {
            return false;
        }
        if (!Objects.equals(this.maxScale, that.maxScale)) {
            return false;
        }
        if (!Objects.equals(this.scaleToZeroEnabled, that.scaleToZeroEnabled)) {
            return false;
        }
        if (!Objects.equals((Object)this.revisionAutoScaling, (Object)that.revisionAutoScaling)) {
            return false;
        }
        if (!Objects.equals((Object)this.globalAutoScaling, (Object)that.globalAutoScaling)) {
            return false;
        }
        if (!Objects.equals(this.templateName, that.templateName)) {
            return false;
        }
        return Objects.equals(this.traffic, that.traffic);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.revisionName, this.host, this.httpTransportVersion, this.expose, this.minScale, this.maxScale, this.scaleToZeroEnabled, this.revisionAutoScaling, this.globalAutoScaling, this.templateName, this.traffic, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.revisionName != null) {
            sb.append("revisionName:");
            sb.append(this.revisionName + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.httpTransportVersion != null) {
            sb.append("httpTransportVersion:");
            sb.append((Object)((Object)this.httpTransportVersion) + ",");
        }
        if (this.expose != null) {
            sb.append("expose:");
            sb.append(this.expose + ",");
        }
        if (this.minScale != null) {
            sb.append("minScale:");
            sb.append(this.minScale + ",");
        }
        if (this.maxScale != null) {
            sb.append("maxScale:");
            sb.append(this.maxScale + ",");
        }
        if (this.scaleToZeroEnabled != null) {
            sb.append("scaleToZeroEnabled:");
            sb.append(this.scaleToZeroEnabled + ",");
        }
        if (this.revisionAutoScaling != null) {
            sb.append("revisionAutoScaling:");
            sb.append((Object)((Object)this.revisionAutoScaling) + ",");
        }
        if (this.globalAutoScaling != null) {
            sb.append("globalAutoScaling:");
            sb.append((Object)((Object)this.globalAutoScaling) + ",");
        }
        if (this.templateName != null) {
            sb.append("templateName:");
            sb.append(this.templateName + ",");
        }
        if (this.traffic != null && !this.traffic.isEmpty()) {
            sb.append("traffic:");
            sb.append(this.traffic);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withExpose() {
        return this.withExpose(true);
    }

    public A withScaleToZeroEnabled() {
        return this.withScaleToZeroEnabled(true);
    }

    public class TrafficNested<N>
    extends TrafficFluent<TrafficNested<N>>
    implements Nested<N> {
        TrafficBuilder builder;
        int index;

        TrafficNested(int index, Traffic item) {
            this.index = index;
            this.builder = new TrafficBuilder(this, item);
        }

        public N and() {
            return (N)KnativeConfigFluent.this.setToTraffic(this.index, this.builder.build());
        }

        public N endTraffic() {
            return this.and();
        }
    }

    public class GlobalAutoScalingNested<N>
    extends GlobalAutoScalingFluent<GlobalAutoScalingNested<N>>
    implements Nested<N> {
        GlobalAutoScalingBuilder builder;

        GlobalAutoScalingNested(GlobalAutoScaling item) {
            this.builder = new GlobalAutoScalingBuilder(this, item);
        }

        public N and() {
            return (N)KnativeConfigFluent.this.withGlobalAutoScaling(this.builder.build());
        }

        public N endGlobalAutoScaling() {
            return this.and();
        }
    }

    public class RevisionAutoScalingNested<N>
    extends AutoScalingFluent<RevisionAutoScalingNested<N>>
    implements Nested<N> {
        AutoScalingBuilder builder;

        RevisionAutoScalingNested(AutoScaling item) {
            this.builder = new AutoScalingBuilder(this, item);
        }

        public N and() {
            return (N)KnativeConfigFluent.this.withRevisionAutoScaling(this.builder.build());
        }

        public N endRevisionAutoScaling() {
            return this.and();
        }
    }
}

