/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.BaseKubernetesListFluent;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressRuleFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressSpecFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Ports;
import java.util.Map;
import java.util.Optional;

@Description(value="Add an ingress to the list.")
public class AddIngressDecorator
extends Decorator<KubernetesListBuilder> {
    private final KubernetesConfig config;
    private final Map<String, String> allLabels;

    public AddIngressDecorator(KubernetesConfig config, Map<String, String> allLabels) {
        this.config = config;
        this.allLabels = allLabels;
    }

    public void visit(KubernetesListBuilder list) {
        Optional p = Ports.getHttpPort((BaseConfig)this.config);
        if (!p.isPresent() || !this.config.isExpose()) {
            return;
        }
        Port port = (Port)p.get();
        ((BaseKubernetesListFluent.IngressItemsNested)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)((BaseKubernetesListFluent.IngressItemsNested)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)list.addNewIngressItem().withNewMetadata().withName(this.config.getName())).withLabels(this.allLabels)).endMetadata()).withNewSpec().addNewRule().withHost(this.config.getHost())).withNewHttp().addNewPath().withPath(port.getPath())).withNewBackend().withServiceName(this.config.getName())).withNewServicePort(Integer.valueOf(port.getContainerPort()))).endBackend()).endPath()).endHttp()).endRule()).endSpec()).endIngressItem();
    }
}

